/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.StrictMode;
import android.os.strictmode.Violation;
import android.support.annotation.NonNull;
import android.util.Log;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;
import com.taobao.monitor.olympic.plugins.strictmode.tranfer.ViolationTransfer28;
import java.util.Locale;

public final class OlympicVmCompat {
    private static final String TAG = "OlympicThreadCompat";
    private static final String FEATURE_NOT_SUPPORTED_MSG = "%s:%s is not supported";

    private OlympicVmCompat() {
    }

    public static void setPolicy(@NonNull Policy policy) {
        StrictMode.setVmPolicy((StrictMode.VmPolicy)policy.mPolicy);
    }

    private static void logUnsupportedFeature(@NonNull String category, @NonNull String feature) {
        Log.d((String)TAG, (String)String.format(Locale.US, FEATURE_NOT_SUPPORTED_MSG, category, feature));
    }

    public static final class Policy {
        private final StrictMode.VmPolicy mPolicy;

        private Policy(StrictMode.VmPolicy policy) {
            this.mPolicy = policy;
        }

        @TargetApi(value=29)
        private static class V29BuilderImpl
        extends V26BuilderImpl {
            V29BuilderImpl() {
            }

            V29BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectImplicitDirectBoot() {
            }

            @Override
            public void detectCredentialProtectedWhileLocked() {
            }
        }

        @TargetApi(value=26)
        private static class V26BuilderImpl
        extends V24BuilderImpl {
            V26BuilderImpl() {
            }

            V26BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectUntaggedSockets() {
                this.mBuilder.detectUntaggedSockets();
            }

            @Override
            public void detectContentUriWithoutPermission() {
                this.mBuilder.detectContentUriWithoutPermission();
            }
        }

        @TargetApi(value=24)
        private static class V24BuilderImpl
        extends V23BuilderImpl {
            V24BuilderImpl() {
            }

            V24BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void penaltyDeathOnFileUriExposure() {
                this.mBuilder.penaltyDeathOnFileUriExposure();
            }
        }

        @TargetApi(value=23)
        private static class V23BuilderImpl
        extends V18BuilderImpl {
            V23BuilderImpl() {
            }

            V23BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectCleartextNetwork() {
                this.mBuilder.detectCleartextNetwork();
            }

            @Override
            public void penaltyDeathOnCleartextNetwork() {
                this.mBuilder.penaltyDeathOnCleartextNetwork();
            }
        }

        @TargetApi(value=18)
        private static class V18BuilderImpl
        extends V16BuilderImpl {
            V18BuilderImpl() {
            }

            V18BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectFileUriExposure() {
                this.mBuilder.detectFileUriExposure();
            }
        }

        @TargetApi(value=16)
        private static class V16BuilderImpl
        extends BaseBuilderImpl {
            V16BuilderImpl() {
            }

            V16BuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                super(policy);
            }

            @Override
            public void detectLeakedRegistrationObjects() {
                this.mBuilder.detectLeakedRegistrationObjects();
            }
        }

        private static class BaseBuilderImpl
        implements BuilderImpl {
            @NonNull
            final StrictMode.VmPolicy.Builder mBuilder;

            BaseBuilderImpl() {
                this.mBuilder = new StrictMode.VmPolicy.Builder();
            }

            BaseBuilderImpl(@NonNull StrictMode.VmPolicy policy) {
                this.mBuilder = new StrictMode.VmPolicy.Builder(policy);
            }

            @Override
            public StrictMode.VmPolicy build() {
                if (Build.VERSION.SDK_INT >= 28) {
                    try {
                        StrictMode.OnVmViolationListener listener = new StrictMode.OnVmViolationListener(){
                            ViolationTransfer28 mTransfer = new ViolationTransfer28();

                            public void onVmViolation(Violation violation) {
                                ViolationSubject.instance().notifyViolation(this.mTransfer.transfer((Throwable)violation));
                            }
                        };
                        this.mBuilder.penaltyListener(Global.instance().executor(), listener);
                    }
                    catch (Throwable t) {
                        Logger.throwException(t);
                    }
                } else {
                    this.mBuilder.penaltyDropBox();
                }
                return this.mBuilder.build();
            }

            @Override
            public void detectAll() {
                this.mBuilder.detectAll();
            }

            @Override
            public void detectCleartextNetwork() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Cleartext network");
            }

            @Override
            public void detectFileUriExposure() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "File uri exposure");
            }

            @Override
            public void detectLeakedSqlLiteObjects() {
                this.mBuilder.detectLeakedSqlLiteObjects();
            }

            @Override
            public void detectLeakedRegistrationObjects() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Leaked registration objects");
            }

            @Override
            public void penaltyDeath() {
                this.mBuilder.penaltyDeath();
            }

            @Override
            public void penaltyDeathOnCleartextNetwork() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Cleartext network");
            }

            @Override
            public void penaltyDeathOnFileUriExposure() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Penalty death on file uri exposure");
            }

            @Override
            public void penaltyDropBox() {
                this.mBuilder.penaltyDropBox();
            }

            @Override
            public void penaltyLog() {
                this.mBuilder.penaltyLog();
            }

            @Override
            public void detectActivityLeaks() {
                this.mBuilder.detectActivityLeaks();
            }

            @Override
            public void detectLeakedClosableObjects() {
                this.mBuilder.detectLeakedClosableObjects();
            }

            @Override
            public void setClassInstanceLimit(@NonNull Class<?> klass, int instanceLimit) {
                this.mBuilder.setClassInstanceLimit(klass, instanceLimit);
            }

            @Override
            public void detectContentUriWithoutPermission() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Content uri without permission");
            }

            @Override
            public void detectUntaggedSockets() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Untagged sockets");
            }

            @Override
            public void detectNonSdkApiUsage() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Non SDK api usage");
            }

            @Override
            public void permitNonSdkApiUsage() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Non SDK api usage");
            }

            @Override
            public void detectImplicitDirectBoot() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Implicit Direct Boot");
            }

            @Override
            public void detectCredentialProtectedWhileLocked() {
                OlympicVmCompat.logUnsupportedFeature("VmPolicy", "Credential Protected While Locked");
            }
        }

        private static interface BuilderImpl {
            public static final String CATEGORY = "VmPolicy";

            public StrictMode.VmPolicy build();

            public void detectActivityLeaks();

            public void detectAll();

            public void detectCleartextNetwork();

            public void detectFileUriExposure();

            public void detectLeakedClosableObjects();

            public void detectLeakedRegistrationObjects();

            public void detectLeakedSqlLiteObjects();

            public void penaltyDeath();

            public void penaltyDeathOnCleartextNetwork();

            public void penaltyDeathOnFileUriExposure();

            public void penaltyDropBox();

            public void penaltyLog();

            public void setClassInstanceLimit(@NonNull Class<?> var1, int var2);

            public void detectContentUriWithoutPermission();

            public void detectUntaggedSockets();

            public void detectNonSdkApiUsage();

            public void permitNonSdkApiUsage();

            public void detectImplicitDirectBoot();

            public void detectCredentialProtectedWhileLocked();
        }

        public static final class Builder {
            @NonNull
            private final BuilderImpl mBuilder;

            public Builder() {
                this.mBuilder = Build.VERSION.SDK_INT >= 29 ? new V29BuilderImpl() : (Build.VERSION.SDK_INT >= 26 ? new V26BuilderImpl() : (Build.VERSION.SDK_INT >= 24 ? new V24BuilderImpl() : (Build.VERSION.SDK_INT >= 23 ? new V23BuilderImpl() : (Build.VERSION.SDK_INT >= 18 ? new V18BuilderImpl() : (Build.VERSION.SDK_INT >= 16 ? new V16BuilderImpl() : new BaseBuilderImpl())))));
            }

            public Builder(@NonNull StrictMode.VmPolicy policy) {
                this.mBuilder = Build.VERSION.SDK_INT >= 29 ? new V29BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 26 ? new V26BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 24 ? new V24BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 23 ? new V23BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 18 ? new V18BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 16 ? new V16BuilderImpl(policy) : new BaseBuilderImpl(policy))))));
            }

            public Policy build() {
                return new Policy(this.mBuilder.build());
            }

            public Builder detectActivityLeaks() {
                this.mBuilder.detectActivityLeaks();
                return this;
            }

            public Builder detectAll() {
                this.mBuilder.detectAll();
                return this;
            }

            public Builder detectCleartextNetwork() {
                this.mBuilder.detectCleartextNetwork();
                return this;
            }

            public Builder detectFileUriExposure() {
                this.mBuilder.detectFileUriExposure();
                return this;
            }

            public Builder detectLeakedClosableObjects() {
                this.mBuilder.detectLeakedClosableObjects();
                return this;
            }

            public Builder detectLeakedRegistrationObjects() {
                this.mBuilder.detectLeakedRegistrationObjects();
                return this;
            }

            public Builder detectLeakedSqlLiteObjects() {
                this.mBuilder.detectLeakedSqlLiteObjects();
                return this;
            }

            public Builder penaltyDeath() {
                this.mBuilder.penaltyDeath();
                return this;
            }

            public Builder penaltyDeathOnCleartextNetwork() {
                this.mBuilder.penaltyDeathOnCleartextNetwork();
                return this;
            }

            public Builder penaltyDeathOnFileUriExposure() {
                this.mBuilder.penaltyDeathOnFileUriExposure();
                return this;
            }

            public Builder penaltyDropBox() {
                this.mBuilder.penaltyDropBox();
                return this;
            }

            public Builder penaltyLog() {
                this.mBuilder.penaltyLog();
                return this;
            }

            public Builder setClassInstanceLimit(@NonNull Class<?> klass, int instanceLimit) {
                this.mBuilder.setClassInstanceLimit(klass, instanceLimit);
                return this;
            }

            public Builder detectContentUriWithoutPermission() {
                this.mBuilder.detectContentUriWithoutPermission();
                return this;
            }

            public Builder detectUntaggedSockets() {
                this.mBuilder.detectUntaggedSockets();
                return this;
            }

            public Builder detectNonSdkApiUsage() {
                this.mBuilder.detectNonSdkApiUsage();
                return this;
            }

            public Builder permitNonSdkApiUsage() {
                this.mBuilder.permitNonSdkApiUsage();
                return this;
            }

            public Builder detectImplicitDirectBoot() {
                this.mBuilder.detectImplicitDirectBoot();
                return this;
            }

            public Builder detectCredentialProtectedWhileLocked() {
                this.mBuilder.detectCredentialProtectedWhileLocked();
                return this;
            }
        }
    }
}

