/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic;

public class ViolationError {
    private final String mType;
    private final int mPolicy;
    private final String mMessage;
    private final String mStackTrace;
    private final String mExceptionMessage;
    private final Throwable mThrowable;

    private ViolationError(Builder builder) {
        this.mType = builder.mType;
        this.mPolicy = builder.mPolicy;
        this.mMessage = builder.mMessage;
        this.mStackTrace = builder.mStackTrace;
        this.mExceptionMessage = builder.mExceptionMessage;
        this.mThrowable = builder.mThrowable;
    }

    public String getType() {
        return this.mType;
    }

    public int getPolicy() {
        return this.mPolicy;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public String getStackTrace() {
        return this.mStackTrace;
    }

    public String getExceptionMessage() {
        return this.mExceptionMessage;
    }

    public Throwable getThrowable() {
        return this.mThrowable;
    }

    public String getSummary() {
        String[] lines;
        if (this.mThrowable != null) {
            String throwableName = this.mThrowable.getClass().getSimpleName();
            String message = this.mThrowable.getMessage();
            if (message != null) {
                return throwableName + ":" + message;
            }
            return throwableName;
        }
        if (this.mStackTrace != null && (lines = this.mStackTrace.split("\n")).length >= 1) {
            return lines[0];
        }
        return this.mMessage != null ? this.mMessage : this.mExceptionMessage;
    }

    public String toString() {
        return "ViolationError{mPolicy=" + this.mPolicy + ", mMessage='" + this.mMessage + '\'' + ", mStackTrace='" + this.mStackTrace + '\'' + ", mExceptionMessage='" + this.mExceptionMessage + '\'' + ", mThrowable=" + this.mThrowable + '}';
    }

    public static class Builder {
        private final String mType;
        private int mPolicy;
        private String mMessage;
        private String mStackTrace;
        private String mExceptionMessage;
        private Throwable mThrowable;

        public Builder(String type) {
            this.mType = type;
        }

        public int getPolicy() {
            return this.mPolicy;
        }

        public Builder setPolicy(int policy) {
            this.mPolicy = policy;
            return this;
        }

        public String getMessage() {
            return this.mMessage;
        }

        public Builder setMessage(String mMessage) {
            this.mMessage = mMessage;
            return this;
        }

        public String getStackTrace() {
            return this.mStackTrace;
        }

        public Builder setStackTrace(String stackTrace) {
            this.mStackTrace = stackTrace;
            return this;
        }

        public String getExceptionMessage() {
            return this.mExceptionMessage;
        }

        public Builder setExceptionMessage(String exceptionMessage) {
            this.mExceptionMessage = exceptionMessage;
            return this;
        }

        public Throwable getThrowable() {
            return this.mThrowable;
        }

        public Builder setThrowable(Throwable throwable) {
            this.mThrowable = throwable;
            return this;
        }

        public ViolationError build() {
            return new ViolationError(this);
        }
    }
}

