/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.anr;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.plugins.Executor;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;
import java.util.List;
import java.util.Map;

public class ANRAnalyzer
implements Executor {
    private static final String TAG = "ANRAnalyzer";

    @Override
    public void execute() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.ANR");
        Context context = Global.instance().context();
        context.registerReceiver((BroadcastReceiver)new ANRReceiver(), intentFilter, null, Global.instance().handler());
    }

    private static class ANRReceiver
    extends BroadcastReceiver {
        private ANRReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Log.e((String)ANRAnalyzer.TAG, (String)"ANR Happened!");
            ActivityManager activityManager = (ActivityManager)Global.instance().context().getSystemService("activity");
            if (activityManager == null) {
                return;
            }
            try {
                List errors = activityManager.getProcessesInErrorState();
                if (errors != null) {
                    for (ActivityManager.ProcessErrorStateInfo error : errors) {
                        if (error.pid != Process.myPid() || error.condition != 2) continue;
                        ViolationSubject.instance().notifyViolation(this.createError(error));
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        @TargetApi(value=14)
        private ViolationError createError(ActivityManager.ProcessErrorStateInfo error) {
            StringBuilder stringBuilder = new StringBuilder(error.longMsg);
            stringBuilder.append("\n");
            Thread thread = Looper.getMainLooper().getThread();
            StackTraceElement[] elements = thread.getStackTrace();
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            map.put(thread, elements);
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                stringBuilder.append("\n");
                Thread t = entry.getKey();
                StackTraceElement[] e = entry.getValue();
                String threadInfo = String.format("\"%s\" prio=%d tid=%d %s", t.getName(), t.getPriority(), t.getId(), t.getState().toString());
                stringBuilder.append(threadInfo).append("\n");
                for (StackTraceElement element : e) {
                    stringBuilder.append("\tat " + element).append("\n");
                }
            }
            ViolationError.Builder builder = new ViolationError.Builder("HA_ANR_INFO");
            builder.setMessage(stringBuilder.toString());
            builder.setExceptionMessage(error.tag);
            return builder.build();
        }
    }
}

