/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.common;

import android.app.ActivityManager;
import android.os.Build;
import android.os.TransactionTooLargeException;
import android.util.Log;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;
import com.taobao.monitor.olympic.utils.ObjectInvoker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ActivityManagerProxy
implements InvocationHandler {
    private static final String TAG = "ActivityManagerHook";
    private static ActivityManagerProxy INSTANCE;
    private final Object real;
    private final List<OnTransactionTooLargeExceptionListener> listeners = new CopyOnWriteArrayList<OnTransactionTooLargeExceptionListener>();

    private ActivityManagerProxy(Object real) {
        this.real = real;
    }

    private static void init(boolean async) {
        Log.d((String)TAG, (String)"start Hook IActivityManager...");
        try {
            Object gDefault = null;
            if (Build.VERSION.SDK_INT >= 26) {
                gDefault = ObjectInvoker.wrap(ActivityManager.class).get("IActivityManagerSingleton").toObject();
            } else {
                Class<?> activityManagerNativeCls = Class.forName("android.app.ActivityManagerNative");
                gDefault = ObjectInvoker.wrap(activityManagerNativeCls).get("gDefault").toObject();
            }
            final ObjectInvoker gDefaultInvoker = ObjectInvoker.wrap(gDefault);
            try {
                gDefaultInvoker.invoke("get", new Object[0]);
            }
            catch (Exception e) {
                Logger.throwException(e);
            }
            Object mInstance = gDefaultInvoker.get("mInstance").toObject();
            if (mInstance == null) {
                Logger.e(TAG, "Hook IActivityManager failed", "mInstance == null");
            }
            final Class<?> activityManagerClass = Class.forName("android.app.IActivityManager");
            INSTANCE = new ActivityManagerProxy(mInstance);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object instanceProxy = Proxy.newProxyInstance(ActivityManagerProxy.class.getClassLoader(), new Class[]{activityManagerClass}, (InvocationHandler)INSTANCE);
                    gDefaultInvoker.set("mInstance", instanceProxy);
                    Logger.d(ActivityManagerProxy.TAG, "Hook IActivityManager success");
                }
            };
            if (async) {
                new Thread(runnable).start();
            } else {
                runnable.run();
            }
        }
        catch (Exception e) {
            Logger.d(TAG, "Hook IActivityManager failed");
            INSTANCE = new ActivityManagerProxy(null);
            Logger.throwException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityManagerProxy instance(boolean async) {
        if (INSTANCE != null) return INSTANCE;
        Class<ActivityManagerProxy> clazz = ActivityManagerProxy.class;
        synchronized (ActivityManagerProxy.class) {
            if (INSTANCE != null) return INSTANCE;
            ActivityManagerProxy.init(async);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("handleApplicationStrictModeViolation")) {
            if (args != null && args.length == 3 && args[1] instanceof Integer) {
                try {
                    ViolationSubject.instance().notifyViolation(args[2]);
                }
                catch (Throwable e) {
                    Logger.throwException(e);
                }
            }
            return null;
        }
        try {
            boolean DEBUG = false;
            return method.invoke(this.real, args);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (Build.VERSION.SDK_INT >= 15 && target instanceof TransactionTooLargeException) {
                for (OnTransactionTooLargeExceptionListener listener : this.listeners) {
                    try {
                        listener.onTransactionTooLargeException((TransactionTooLargeException)target, method, args);
                    }
                    catch (Throwable throwable) {}
                }
            }
            throw target;
        }
    }

    public void addOnTransactionTooLargeExceptionListener(OnTransactionTooLargeExceptionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public static interface OnTransactionTooLargeExceptionListener {
        public void onTransactionTooLargeException(TransactionTooLargeException var1, Method var2, Object[] var3);
    }
}

