/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.common;

import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;

public class BFSubject {
    private ArrayList<Observer> mObservers = new ArrayList();

    private BFSubject() {
    }

    public static BFSubject instance() {
        return Holder.INSTANCE;
    }

    public void notifyBackground() {
        this.checkThread();
        for (Observer observer : this.mObservers) {
            observer.onBackground();
        }
    }

    public void notifyForeground() {
        this.checkThread();
        for (Observer observer : this.mObservers) {
            observer.onForeground();
        }
    }

    public void addObserver(final Observer observer) {
        this.runOnMain(new Runnable(){

            @Override
            public void run() {
                BFSubject.this.mObservers.add(observer);
            }
        });
    }

    public void removeObserver(final Observer observer) {
        this.runOnMain(new Runnable(){

            @Override
            public void run() {
                BFSubject.this.mObservers.remove(observer);
            }
        });
    }

    private void checkThread() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException();
        }
    }

    private boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    private void runOnMain(Runnable runnable) {
        if (this.isMainThread()) {
            runnable.run();
        } else {
            new Handler(Looper.getMainLooper()).post(runnable);
        }
    }

    public static interface Observer {
        public void onBackground();

        public void onForeground();
    }

    private static class Holder {
        private static BFSubject INSTANCE = new BFSubject();

        private Holder() {
        }
    }
}

