/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import com.taobao.monitor.olympic.common.BFSubject;
import com.taobao.monitor.olympic.utils.DebugUtils;
import java.util.concurrent.Executor;

public class Global {
    private Context mContext;
    private Handler mHandler;
    private String mCurrentPageName;
    private final Object mHandlerLock = new Object();
    private final InnerExecutor mExecutor = new InnerExecutor();

    private Global() {
    }

    public static Global instance() {
        return Holder.INSTANCE;
    }

    public Context context() {
        return this.mContext;
    }

    public void setContext(Context context) {
        if (!(context instanceof Application)) {
            throw new IllegalArgumentException("Context must be 'Application' type");
        }
        this.mContext = context;
    }

    public void initAppLifecycle() {
        ((Application)this.mContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new AppLifeCycle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler handler() {
        if (this.mHandler == null) {
            Object object = this.mHandlerLock;
            synchronized (object) {
                if (this.mHandler == null) {
                    HandlerThread handlerThread = new HandlerThread("Olympic");
                    handlerThread.start();
                    this.mHandler = new Handler(handlerThread.getLooper());
                }
            }
        }
        return this.mHandler;
    }

    public Executor executor() {
        return this.mExecutor;
    }

    public String getCurrentPageName() {
        return this.mCurrentPageName;
    }

    public void setHandler(Handler handler) {
        if (this.mHandler != handler && handler != null) {
            this.mHandler = handler;
        }
    }

    private class InnerExecutor
    implements Executor {
        private InnerExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            Global.this.handler().post(command);
        }
    }

    private class AppLifeCycle
    implements Application.ActivityLifecycleCallbacks {
        private int count = 0;

        private AppLifeCycle() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
            Global.this.mCurrentPageName = activity.getClass().getName();
            if (this.count == 0) {
                BFSubject.instance().notifyForeground();
            }
            ++this.count;
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            --this.count;
            if (this.count == 0) {
                BFSubject.instance().notifyBackground();
            }
            if (this.count < 0) {
                this.count = 0;
                if (DebugUtils.isDebuggable()) {
                    throw new IllegalStateException();
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }

    private static class Holder {
        static final Global INSTANCE = new Global();

        private Holder() {
        }
    }
}

