/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.logger;

import android.util.Log;

public class Logger {
    private static final String TAG = "OlympicLogger";
    private static boolean isDebug = false;

    private Logger() {
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static void setDebug(boolean isDebug) {
        Logger.isDebug = isDebug;
    }

    public static void i(String tag, Object ... msg) {
        if (isDebug) {
            String s = Logger.format2String(msg);
            Log.i((String)TAG, (String)(tag + ":" + s));
        }
    }

    public static void d(String tag, Object ... msg) {
        if (isDebug) {
            String s = Logger.format2String(msg);
            Log.d((String)TAG, (String)(tag + ":" + s));
        }
    }

    public static void e(String tag, Object ... msg) {
        String s = Logger.format2String(msg);
        Log.e((String)TAG, (String)(tag + ":" + s));
    }

    public static void w(String tag, Object ... msg) {
        if (isDebug) {
            String s = Logger.format2String(msg);
            Log.w((String)TAG, (String)(tag + ":" + s));
        }
    }

    public static void throwException(Throwable e) {
        if (isDebug) {
            throw new RuntimeException(e);
        }
    }

    public static void printThrowable(Throwable e) {
        if (isDebug) {
            e.printStackTrace();
        }
    }

    private static String format2String(Object ... objects) {
        if (objects != null) {
            StringBuilder builder = new StringBuilder();
            for (Object o : objects) {
                if (o == null) continue;
                builder.append("->").append(o.toString());
            }
            return builder.toString();
        }
        return "";
    }
}

