/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins;

import android.support.annotation.Keep;
import com.taobao.monitor.olympic.common.Switcher;
import com.taobao.monitor.olympic.plugins.Plugin;
import java.util.HashSet;
import java.util.Set;

@Keep
public abstract class BasePlugin
implements Plugin {
    private static Set<Class> sRunOnceSet = new HashSet<Class>();

    @Override
    public final void execute() {
        this.runOnceOnly();
    }

    private void runOnceOnly() {
        if (!sRunOnceSet.contains(this.getClass()) && this.condition()) {
            try {
                this.onExecute();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sRunOnceSet.add(this.getClass());
        }
    }

    protected abstract void onExecute();

    protected boolean condition() {
        return Switcher.value(this.getSimpleName(), true);
    }

    protected abstract String getSimpleName();
}

