/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.bitmap;

import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import com.taobao.monitor.olympic.OlympicPerformanceMode;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.Switcher;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.plugins.bitmap.OverBitmapViolation;
import com.taobao.monitor.olympic.plugins.bitmap.UiAnalyzer;
import com.taobao.monitor.olympic.plugins.bitmap.WebPathUtils;
import com.taobao.monitor.olympic.utils.ObjectInvoker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OverBitmapAnalyzer
implements UiAnalyzer {
    private static final double IMG_SIZE_THRESHOLD = 2.25;
    private final String mPageName;
    private final String mPageUrl;

    public OverBitmapAnalyzer(String mPageName, String mPageUrl) {
        this.mPageName = mPageName;
        this.mPageUrl = mPageUrl;
    }

    @Override
    public void analysis(View view) {
        this.innerAnalysis(view);
    }

    private void innerAnalysis(View view) {
        Map<String, String> errorInfo;
        ImageView imageView;
        Drawable drawable;
        Map<String, String> errorInfo2;
        Drawable background = this.getRealDrawable(view.getBackground());
        if (background != null && (errorInfo2 = this.checkDrawable(view, background)) != null) {
            HashMap<String, String> errors = new HashMap<String, String>(errorInfo2);
            errors.put("type", "background");
            errors.put("viewId", this.viewId(view));
            OlympicPerformanceMode.onOverBitmap(this.createError(view, errors));
        }
        if (view instanceof ImageView && (drawable = this.getRealDrawable((imageView = (ImageView)view).getDrawable())) != null && (errorInfo = this.checkDrawable(view, drawable)) != null) {
            HashMap<String, String> errors = new HashMap<String, String>(errorInfo);
            errors.put("type", "image");
            errors.put("viewId", this.viewId(view));
            errors.put("src", this.imageUrl(imageView));
            OlympicPerformanceMode.onOverBitmap(this.createError(view, errors));
        }
    }

    private Map<String, String> checkDrawable(View container, Drawable drawable) {
        int drawableHeight;
        if (!this.hasBitmap(drawable)) {
            return null;
        }
        int width = container.getMeasuredWidth();
        int height = container.getMeasuredHeight();
        int drawableWidth = drawable.getIntrinsicWidth();
        int drawablePixelSize = drawableWidth * (drawableHeight = drawable.getIntrinsicHeight());
        int drawableMemorySize = drawablePixelSize * 4 / 1024;
        if (drawableMemorySize >= Switcher.value("BitmapSize", 512) && (double)drawablePixelSize > 2.25 * (double)width * (double)height) {
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("Drawable", drawable.getClass().getSimpleName());
            errors.put("ViewSize", width + "*" + height);
            errors.put("ImageSize", drawableWidth + "*" + drawableHeight + "=" + drawablePixelSize * 4 / 1024 + "KB");
            return errors;
        }
        return null;
    }

    private boolean hasBitmap(Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 28) {
            return drawable instanceof BitmapDrawable || drawable instanceof NinePatchDrawable || drawable instanceof AnimationDrawable || drawable instanceof AnimatedImageDrawable;
        }
        return drawable instanceof BitmapDrawable || drawable instanceof NinePatchDrawable || drawable instanceof AnimationDrawable;
    }

    private String imageUrl(ImageView imageView) {
        String imageUrl = "";
        ObjectInvoker imageInvoker = ObjectInvoker.wrap(imageView);
        try {
            if (this.isTaoImageView(imageView) && (imageUrl = (String)imageInvoker.invoke("getImageUrl", new Object[0]).toObject()) != null && imageUrl.startsWith("//")) {
                imageUrl = "http:" + imageUrl;
            }
        }
        catch (Exception e) {
            Logger.throwException(e);
        }
        try {
            int mResource;
            if (TextUtils.isEmpty((CharSequence)imageUrl) && (mResource = ((Integer)imageInvoker.get("mResource").toObject()).intValue()) > 65535) {
                try {
                    imageUrl = imageView.getResources().getResourceName(mResource);
                }
                catch (Exception e) {
                    e.getStackTrace();
                }
            }
        }
        catch (Exception e) {
            Logger.throwException(e);
        }
        return imageUrl;
    }

    private String viewId(View view) {
        int id = view.getId();
        if (id > 65535) {
            try {
                return view.getResources().getResourceName(id);
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
        return "NoResId";
    }

    private Drawable getRealDrawable(Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 23 && drawable instanceof DrawableWrapper) {
            drawable = ((DrawableWrapper)drawable).getDrawable();
        }
        return drawable;
    }

    private boolean isTaoImageView(ImageView imageView) {
        Class<?> c;
        String simpleName = c.getSimpleName();
        for (c = imageView.getClass(); c != Object.class && c != ImageView.class; c = c.getSuperclass()) {
            if (!"TUrlImageView".equals(simpleName) && !"LoadableImageView".equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    private ViolationError createError(View view, Map<String, String> errors) {
        OverBitmapViolation violation = new OverBitmapViolation(errors.toString());
        violation.setStackTrace(this.view2Stack(view));
        ViolationError.Builder builder = new ViolationError.Builder("HA_BIG_BITMAP");
        builder.setMessage("\u56fe\u7247\u5185\u5b58\u8fdc\u8d85\u63a7\u4ef6\u5b9e\u9645\u5927\u5c0f" + this.mPageName + ", url:" + WebPathUtils.getUrlPath(this.mPageUrl) + "viewId:" + errors.get("viewId"));
        builder.setThrowable(violation);
        builder.setExceptionMessage(this.mPageName + "_viewId:" + errors.get("viewId"));
        return builder.build();
    }

    private StackTraceElement[] view2Stack(View child) {
        ArrayList<StackTraceElement> elementList = new ArrayList<StackTraceElement>();
        ViewParent parent = child.getParent();
        while (parent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)parent;
            StackTraceElement element = new StackTraceElement(viewGroup.getClass().getSimpleName(), "view", "SubIndex", viewGroup.indexOfChild(child));
            elementList.add(element);
            child = viewGroup;
            parent = child.getParent();
        }
        return elementList.toArray(new StackTraceElement[0]);
    }
}

