/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.bitmap;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.view.View;
import android.view.Window;
import com.taobao.monitor.olympic.OlympicPerformanceMode;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.plugins.BasePlugin;
import com.taobao.monitor.olympic.plugins.bitmap.OverBitmapAnalyzer;
import com.taobao.monitor.olympic.plugins.bitmap.UiErgodicImpl;
import java.util.HashSet;

@Keep
public class OverBitmapPluginImpl
extends BasePlugin {
    @Override
    @TargetApi(value=14)
    protected void onExecute() {
        Application application = (Application)Global.instance().context();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new AppLifeCycle());
    }

    @Override
    protected String getSimpleName() {
        return "OverBitmapPluginImpl";
    }

    @TargetApi(value=14)
    private class AppLifeCycle
    implements Application.ActivityLifecycleCallbacks {
        HashSet<Class<? extends Activity>> mSet = new HashSet();

        private AppLifeCycle() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
            if (!OlympicPerformanceMode.detectOverBitmapEnabled()) {
                return;
            }
            Class<?> clazz = activity.getClass();
            if (!this.mSet.contains(clazz)) {
                Window window = activity.getWindow();
                if (window != null) {
                    View decor = window.getDecorView();
                    String pageName = clazz.getName();
                    Intent intent = activity.getIntent();
                    String url = intent == null ? "" : intent.getDataString();
                    UiErgodicImpl ergodic = new UiErgodicImpl(new OverBitmapAnalyzer(pageName, url));
                    ergodic.ergodic(decor);
                }
                this.mSet.add(clazz);
            }
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

