/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.block;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Keep;
import com.taobao.monitor.olympic.OlympicPerformanceMode;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.plugins.BasePlugin;
import com.taobao.monitor.olympic.plugins.block.MainBlockedViolation;
import com.taobao.monitor.olympic.plugins.block.MessageQueueProxy;

@Keep
public class MainBlockedPluginImpl
extends BasePlugin
implements Runnable {
    private static final String TAG = "MainBlockedPluginImpl";
    private static final long INTERVAL = 1000L;
    private Handler mWorkHandler = Global.instance().handler();
    private String mLastMessageHashCode = "NULL_MESSAGE_HASH_CODE";
    private String currentPageName = "";
    private boolean isBackGround = false;
    private String lastSendMessageHashCode = "NULL_MESSAGE_HASH_CODE";

    @Override
    public void run() {
        if (OlympicPerformanceMode.detectMainThreadBlockedEnabled()) {
            this.mainThreadCheck();
        }
        if (!this.isBackGround) {
            this.mWorkHandler.postDelayed((Runnable)this, 1000L);
        }
    }

    private void mainThreadCheck() {
        String currentMessageHashCode = MessageQueueProxy.messageHashCode();
        if (this.mLastMessageHashCode.equals(currentMessageHashCode) && !this.mLastMessageHashCode.equals("NULL_MESSAGE_HASH_CODE")) {
            if (!this.lastSendMessageHashCode.equals(this.mLastMessageHashCode)) {
                this.sendMainBlockInfo();
                this.lastSendMessageHashCode = this.mLastMessageHashCode;
            }
        } else {
            this.mLastMessageHashCode = currentMessageHashCode;
        }
    }

    private void sendMainBlockInfo() {
        Thread mainThread = Looper.getMainLooper().getThread();
        StackTraceElement[] mainThreadTrace = mainThread.getStackTrace();
        if (mainThreadTrace != null) {
            String methodName = null;
            for (StackTraceElement element : mainThreadTrace) {
                methodName = element.getMethodName();
                if ("nativePollOnce".equals(methodName)) {
                    return;
                }
                if (!methodName.contains("nSyncAndDrawFrame") && !methodName.contains("nativeOnVSync")) continue;
                return;
            }
            MainBlockedViolation throwable = new MainBlockedViolation();
            throwable.setStackTrace(mainThreadTrace);
            OlympicPerformanceMode.onMainThreadBlocked(this.createError(throwable));
        }
    }

    @Override
    protected void onExecute() {
        Application application = (Application)Global.instance().context();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new AppLifeCycle());
        this.mWorkHandler.post((Runnable)this);
    }

    @Override
    protected String getSimpleName() {
        return TAG;
    }

    private ViolationError createError(Throwable throwable) {
        ViolationError.Builder builder = new ViolationError.Builder("HA_MAIN_THREAD_BLOCK");
        builder.setThrowable(throwable);
        builder.setMessage(this.currentPageName);
        return builder.build();
    }

    private class AppLifeCycle
    implements Application.ActivityLifecycleCallbacks {
        private int count = 0;

        private AppLifeCycle() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
            ++this.count;
            MainBlockedPluginImpl.this.currentPageName = activity.getClass().getName();
            if (this.count == 1) {
                MainBlockedPluginImpl.this.isBackGround = false;
                MainBlockedPluginImpl.this.mWorkHandler.removeCallbacks((Runnable)MainBlockedPluginImpl.this);
                MainBlockedPluginImpl.this.mWorkHandler.post((Runnable)MainBlockedPluginImpl.this);
            }
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            --this.count;
            if (this.count == 0) {
                MainBlockedPluginImpl.this.currentPageName = "background";
                MainBlockedPluginImpl.this.isBackGround = true;
                MainBlockedPluginImpl.this.mWorkHandler.removeCallbacks((Runnable)MainBlockedPluginImpl.this);
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

