/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.block;

import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.plugins.block.LongCostMessageViolation;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;
import com.taobao.monitor.olympic.utils.ObjectInvoker;

public class MessageLooper
implements Runnable {
    private static final int WATCH_DURATION = 500;

    @Override
    public void run() {
        MessageLooper.loop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loop() {
        Looper me = Looper.myLooper();
        if (me == null) {
            throw new RuntimeException("No Looper; Looper.prepare() wasn't called on this thread.");
        }
        ObjectInvoker queueInvoker = ObjectInvoker.wrap(me).get("mQueue");
        ObjectInvoker messageInvoker;
        Message message;
        while ((message = (Message)(messageInvoker = queueInvoker.invoke("next", new Object[0])).toObject()) != null) {
            long dispatchEnd;
            long dispatchStart = SystemClock.uptimeMillis();
            WatchDog watchDog = new WatchDog();
            Global.instance().handler().postDelayed((Runnable)watchDog, 500L);
            try {
                message.getTarget().dispatchMessage(message);
            }
            finally {
                Global.instance().handler().removeCallbacks((Runnable)watchDog);
                dispatchEnd = SystemClock.uptimeMillis();
            }
            long duration = dispatchEnd - dispatchStart;
            if (duration > 500L) {
                MessageLooper.analysisMessage(message, watchDog.elements, duration);
            }
            messageInvoker.invoke("recycleUnchecked", new Object[0]);
        }
        return;
    }

    private static void analysisMessage(Message msg, StackTraceElement[] elements, long costTime) {
        ViolationError error = MessageLooper.createError(new LongCostMessageViolation(msg.toString(), elements), costTime);
        ViolationSubject.instance().notifyViolation(error);
    }

    private static ViolationError createError(Throwable throwable, long time) {
        ViolationError.Builder builder = new ViolationError.Builder("HA_MAIN_THREAD_BLOCK");
        builder.setMessage(String.valueOf(time));
        builder.setThrowable(throwable);
        return builder.build();
    }

    private static class WatchDog
    implements Runnable {
        private StackTraceElement[] elements;

        private WatchDog() {
        }

        @Override
        public void run() {
            Thread thread = Looper.getMainLooper().getThread();
            this.elements = thread.getStackTrace();
        }
    }
}

