/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.block;

import android.os.Build;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.taobao.monitor.olympic.utils.ObjectInvoker;

class MessageQueueProxy {
    static final String NULL_MESSAGE_HASH_CODE = "NULL_MESSAGE_HASH_CODE";
    private static ObjectInvoker sMessageQueueInvoker;
    private static boolean sSuccess;

    MessageQueueProxy() {
    }

    static Message getCurrentMessage() {
        if (sSuccess) {
            try {
                return (Message)sMessageQueueInvoker.get("mMessages").toObject();
            }
            catch (Exception e) {
                sSuccess = false;
            }
        }
        return null;
    }

    static String messageHashCode() {
        Message message = MessageQueueProxy.getCurrentMessage();
        long currentTime = SystemClock.uptimeMillis();
        if (message != null && currentTime > message.getWhen()) {
            return "" + message.hashCode() + message.getWhen();
        }
        return NULL_MESSAGE_HASH_CODE;
    }

    static {
        sSuccess = false;
        if (Build.VERSION.SDK_INT >= 23) {
            sMessageQueueInvoker = ObjectInvoker.wrap(Looper.getMainLooper().getQueue());
            sSuccess = true;
        } else {
            try {
                sMessageQueueInvoker = ObjectInvoker.wrap(Looper.getMainLooper()).get("mQueue");
                sSuccess = true;
            }
            catch (Exception e) {
                sSuccess = false;
            }
        }
    }
}

