/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.crash;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.util.ArrayMap;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.plugins.crash.CrashInterceptor;
import com.taobao.monitor.olympic.utils.ObjectInvoker;
import java.util.HashMap;
import java.util.Map;

public class RegisterTooManyReceiverCrash
implements CrashInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> uncaughtException(Thread t, Throwable e) {
        if (e instanceof AssertionError && "Register too many Broadcast Receivers".equals(e.getMessage())) {
            ArrayMap receivers;
            Application application = (Application)Global.instance().context();
            ObjectInvoker loadedApkInvoker = ObjectInvoker.wrap(application).get("mLoadedApk");
            ArrayMap arrayMap = receivers = (ArrayMap)loadedApkInvoker.get("mReceivers").toObject();
            synchronized (arrayMap) {
                return this.analysisBroadcastReceiver(receivers);
            }
        }
        return null;
    }

    @TargetApi(value=19)
    private Map<String, String> analysisBroadcastReceiver(ArrayMap<Context, ArrayMap<BroadcastReceiver, ?>> receivers) {
        HashMap<String, Integer> registerMap = new HashMap<String, Integer>();
        for (int i = 0; i < receivers.size(); ++i) {
            ArrayMap rmap = (ArrayMap)receivers.get((Object)i);
            for (int j = 0; j < rmap.size(); ++j) {
                BroadcastReceiver receiver = (BroadcastReceiver)rmap.keyAt(j);
                String name = receiver.getClass().getName();
                Integer count = (Integer)registerMap.get(name);
                if (count == null) {
                    registerMap.put(name, 1);
                    continue;
                }
                count = count + 1;
                registerMap.put(name, count);
            }
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("TooManyBroadcast", registerMap.toString());
        return ret;
    }
}

