/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.memleak;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.Keep;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.plugins.BasePlugin;
import com.taobao.monitor.olympic.plugins.memleak.MemLeakedMode;

@Keep
public class ActivityLeakedPluginImpl
extends BasePlugin {
    @Override
    @TargetApi(value=14)
    protected void onExecute() {
        Application application = (Application)Global.instance().context();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new AppLifeCycle());
    }

    @Override
    protected String getSimpleName() {
        return "ActivityLeakedPluginImpl";
    }

    @TargetApi(value=14)
    private class AppLifeCycle
    implements Application.ActivityLifecycleCallbacks {
        private int count = 0;

        private AppLifeCycle() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
            ++this.count;
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            --this.count;
            if (this.count < 0) {
                this.count = 0;
            }
            if (this.count == 0) {
                MemLeakedMode.detectMemLeaked();
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            MemLeakedMode.delayDetectMemLeaked(activity);
        }
    }
}

