/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.memleak;

import android.os.SystemClock;
import com.taobao.monitor.olympic.OlympicPerformanceMode;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.common.Switcher;
import com.taobao.monitor.olympic.plugins.memleak.InstanceCountViolation;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MemLeakedMode {
    private static final String TAG = "MemLeakedMode";
    private static long KEEP_ALIVE_TIME = 300000L;
    private static final List<MemWeakRef> sWeakLeakObjects = new LinkedList<MemWeakRef>();

    public static void delayDetectMemLeaked(Object object) {
        if (OlympicPerformanceMode.detectActivityLeakedEnabled()) {
            MemLeakedMode.runInSameThread(MemLeakedMode.createAddTask(object));
        }
    }

    public static void detectMemLeaked() {
        if (OlympicPerformanceMode.detectActivityLeakedEnabled()) {
            MemLeakedMode.runInSameThread(MemLeakedMode.createCheckLeakedTask());
        }
    }

    private static Runnable createAddTask(final Object object) {
        return new Runnable(){

            @Override
            public void run() {
                sWeakLeakObjects.add(new MemWeakRef(object));
            }
        };
    }

    private static Runnable createCheckLeakedTask() {
        return new Runnable(){

            @Override
            public void run() {
                if (sWeakLeakObjects.size() == 0) {
                    return;
                }
                long uptimeMillis = SystemClock.uptimeMillis();
                Iterator iterator = sWeakLeakObjects.iterator();
                while (iterator.hasNext()) {
                    MemWeakRef weakRef = (MemWeakRef)iterator.next();
                    Object leakObject = weakRef.get();
                    if (leakObject == null) {
                        iterator.remove();
                        continue;
                    }
                    long deadTimeMillis = weakRef.mDeadTimeMillis;
                    if (uptimeMillis - deadTimeMillis <= KEEP_ALIVE_TIME) break;
                    int instances = InstanceTracker.putInstance(leakObject);
                    if (instances > 1) {
                        MemLeakedMode.runInSameThread(MemLeakedMode.doDumpLeakedObjectTask());
                        break;
                    }
                    iterator.remove();
                    break;
                }
            }
        };
    }

    private static Runnable doDumpLeakedObjectTask() {
        return new Runnable(){

            @Override
            public void run() {
                if (Switcher.value("ForceGc", true)) {
                    MemLeakedMode.forceGc();
                }
                long uptimeMillis = SystemClock.uptimeMillis();
                Iterator iterator = sWeakLeakObjects.iterator();
                while (iterator.hasNext()) {
                    MemWeakRef weakRef = (MemWeakRef)iterator.next();
                    Object leakedObject = weakRef.get();
                    if (leakedObject == null) {
                        iterator.remove();
                        continue;
                    }
                    long deadTimeMillis = weakRef.mDeadTimeMillis;
                    if (uptimeMillis - deadTimeMillis <= KEEP_ALIVE_TIME) break;
                    Class<?> leakedClass = leakedObject.getClass();
                    int instances = InstanceTracker.getInstance(leakedClass);
                    if (instances > 1) {
                        ViolationError error = MemLeakedMode.createError(new InstanceCountViolation(leakedClass, instances));
                        OlympicPerformanceMode.onActivityLeaked(error);
                    }
                    iterator.remove();
                }
            }
        };
    }

    private static void forceGc() {
        Runtime.getRuntime().gc();
        Runtime.runFinalizersOnExit((boolean)false);
        Runtime.getRuntime().gc();
    }

    private static ViolationError createError(Throwable throwable) {
        ViolationError.Builder builder = new ViolationError.Builder("HA_MEM_LEAK");
        builder.setThrowable(throwable);
        builder.setMessage("No_Page");
        return builder.build();
    }

    private static void runInSameThread(Runnable runnable) {
        Global.instance().handler().post(runnable);
    }

    private static final class InstanceTracker {
        private static final HashMap<Class<?>, LinkedList<WeakReference<?>>> sInstanceCounts = new HashMap();

        private InstanceTracker() {
        }

        private static int putInstance(Object leakedObject) {
            Class<?> klass = leakedObject.getClass();
            LinkedList<WeakReference<?>> values = sInstanceCounts.get(klass);
            if (values == null) {
                values = new LinkedList();
                sInstanceCounts.put(klass, values);
            }
            values.add(new WeakReference<Object>(leakedObject));
            if (values.size() == 1) {
                return 1;
            }
            return InstanceTracker.validRefCount(values);
        }

        private static int getInstance(Class klass) {
            LinkedList<WeakReference<?>> values = sInstanceCounts.get(klass);
            if (values == null) {
                return 0;
            }
            return InstanceTracker.validRefCount(values);
        }

        private static int validRefCount(LinkedList<WeakReference<?>> values) {
            Iterator iterator = values.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                WeakReference reference = (WeakReference)iterator.next();
                if (reference.get() == null) {
                    iterator.remove();
                    continue;
                }
                ++count;
            }
            return count;
        }
    }

    private static class MemWeakRef
    extends WeakReference {
        private final long mDeadTimeMillis = SystemClock.uptimeMillis();

        private MemWeakRef(Object referent) {
            super(referent);
        }
    }
}

