/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.memleak;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.support.annotation.Keep;
import android.util.ArrayMap;
import com.taobao.monitor.olympic.OlympicPerformanceMode;
import com.taobao.monitor.olympic.common.BFSubject;
import com.taobao.monitor.olympic.plugins.memleak.ContextLeakedPlugin;
import com.taobao.monitor.olympic.plugins.memleak.LeakedContextRef;
import com.taobao.monitor.olympic.plugins.memleak.MultiReceiverViolation;
import com.taobao.monitor.olympic.utils.ObjectInvoker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@Keep
public class MultiReceiverPluginImpl
extends ContextLeakedPlugin
implements BFSubject.Observer {
    private ArrayMap<Context, ArrayMap<BroadcastReceiver, ?>> mReceivers;
    private HashSet<String> mHasLeakedReceiver = new HashSet();
    private boolean mHasException = false;

    @Override
    protected void onExecute() {
        ObjectInvoker loadedApkInvoker = this.getLoadedApkInvoker();
        this.mReceivers = (ArrayMap)loadedApkInvoker.get("mReceivers").toObject();
        BFSubject.instance().addObserver(this);
    }

    @Override
    protected String getSimpleName() {
        return "MultiReceiverPluginImpl";
    }

    @Override
    public void onBackground() {
        if (!this.mHasException && OlympicPerformanceMode.detectMultiRegisterReceiverEnabled()) {
            this.runTask(this.createCheckTask());
        }
    }

    @Override
    public void onForeground() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    private void doCheck() {
        ArrayMap receivers = new ArrayMap();
        ArrayMap<Context, ArrayMap<BroadcastReceiver, ?>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            receivers.putAll(this.mReceivers);
        }
        for (int i = 0; i < receivers.size(); ++i) {
            Context context = (Context)receivers.keyAt(i);
            ArrayMap rmap = null;
            ArrayMap<Context, ArrayMap<BroadcastReceiver, ?>> arrayMap2 = this.mReceivers;
            synchronized (arrayMap2) {
                rmap = new ArrayMap((ArrayMap)receivers.valueAt(i));
            }
            HashMap<String, Object> lastRegisterObject = new HashMap<String, Object>();
            HashMap<String, LeakedContextRef<BroadcastReceiver>> leakedObjects = new HashMap<String, LeakedContextRef<BroadcastReceiver>>();
            HashMap<String, Integer> registerCount = new HashMap<String, Integer>();
            for (int j = 0; j < rmap.size(); ++j) {
                BroadcastReceiver receiver = (BroadcastReceiver)rmap.keyAt(j);
                String name = receiver.getClass().getName();
                String contextName = context.getClass().getName();
                Object rd = rmap.valueAt(j);
                Integer count = (Integer)registerCount.get(name);
                if (count != null) {
                    registerCount.put(name, count + 1);
                    Object lastRd = lastRegisterObject.get(name);
                    if (lastRd == null) continue;
                    LeakedContextRef<BroadcastReceiver> ref = new LeakedContextRef<BroadcastReceiver>(contextName, rd, lastRd, receiver);
                    leakedObjects.put(name, ref);
                    continue;
                }
                lastRegisterObject.put(name, rd);
                registerCount.put(name, 1);
            }
            for (Map.Entry entry : leakedObjects.entrySet()) {
                LeakedContextRef ref;
                String key = (String)entry.getKey();
                Integer count = (Integer)registerCount.get(key);
                if (count == null || (ref = (LeakedContextRef)leakedObjects.get(key)) == null) continue;
                this.receiverRdLeaked(ref, count);
            }
        }
    }

    private void receiverRdLeaked(LeakedContextRef<BroadcastReceiver> ref, int count) {
        BroadcastReceiver receiver = ref.getLeakedContext();
        String leakedName = receiver.getClass().getName();
        if (this.mHasLeakedReceiver.contains(leakedName)) {
            return;
        }
        this.mHasLeakedReceiver.add(leakedName);
        String contextName = ref.getContextName();
        Object rd = ref.getCurrentLeakedObject();
        Object lastRd = ref.getLastLeakedObject();
        String info = "Register instances=" + count + " " + contextName + "/" + leakedName + " has leaked IntentReceiver originally registered here. Are you missing a call to unregisterReceiver()?";
        Throwable cause = (Throwable)ObjectInvoker.wrap(lastRd).get("mLocation").toObject();
        Throwable self = (Throwable)ObjectInvoker.wrap(rd).get("mLocation").toObject();
        MultiReceiverViolation leak = new MultiReceiverViolation(info, cause);
        leak.setStackTrace(self.getStackTrace());
        OlympicPerformanceMode.onMultiRegisterReceiver(this.buildError(info, leak));
    }

    private Runnable createCheckTask() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (!MultiReceiverPluginImpl.this.mHasException) {
                        MultiReceiverPluginImpl.this.doCheck();
                    }
                }
                catch (Exception e) {
                    MultiReceiverPluginImpl.this.mHasException = true;
                }
            }
        };
    }
}

