/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.memleak;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.ServiceConnection;
import android.support.annotation.Keep;
import android.util.ArrayMap;
import com.taobao.monitor.olympic.OlympicPerformanceMode;
import com.taobao.monitor.olympic.common.BFSubject;
import com.taobao.monitor.olympic.plugins.memleak.ContextLeakedPlugin;
import com.taobao.monitor.olympic.plugins.memleak.LeakedContextRef;
import com.taobao.monitor.olympic.plugins.memleak.MultiServiceViolation;
import com.taobao.monitor.olympic.utils.ObjectInvoker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@Keep
public class MultiServicePluginImpl
extends ContextLeakedPlugin
implements BFSubject.Observer {
    private ArrayMap<Context, ArrayMap<ServiceConnection, ?>> mServices;
    private HashSet<String> mHasLeakedServices = new HashSet();
    private boolean mHasException = false;

    @Override
    protected void onExecute() {
        ObjectInvoker loadedApkInvoker = this.getLoadedApkInvoker();
        this.mServices = (ArrayMap)loadedApkInvoker.get("mServices").toObject();
        BFSubject.instance().addObserver(this);
    }

    @Override
    protected String getSimpleName() {
        return "MultiServicePluginImpl";
    }

    @Override
    public void onBackground() {
        if (!this.mHasException && OlympicPerformanceMode.detectMultiBindServiceEnabled()) {
            this.runTask(this.createCheckTask());
        }
    }

    @Override
    public void onForeground() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    private void doCheck() {
        ArrayMap services = new ArrayMap();
        ArrayMap<Context, ArrayMap<ServiceConnection, ?>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            services.putAll(this.mServices);
        }
        for (int i = 0; i < services.size(); ++i) {
            Context context = (Context)services.keyAt(i);
            ArrayMap smap = null;
            ArrayMap<Context, ArrayMap<ServiceConnection, ?>> arrayMap2 = this.mServices;
            synchronized (arrayMap2) {
                smap = new ArrayMap((ArrayMap)services.valueAt(i));
            }
            HashMap<String, LeakedContextRef<ServiceConnection>> leakedObjects = new HashMap<String, LeakedContextRef<ServiceConnection>>();
            HashMap<String, Integer> registerCount = new HashMap<String, Integer>();
            HashMap<String, Object> lastRegisterObject = new HashMap<String, Object>();
            for (int j = 0; j < smap.size(); ++j) {
                ServiceConnection connection = (ServiceConnection)smap.keyAt(j);
                String connectionName = connection.getClass().getName();
                String contextName = context.getClass().getName();
                Object rd = smap.valueAt(j);
                Integer count = (Integer)registerCount.get(connectionName);
                if (count != null) {
                    registerCount.put(connectionName, count + 1);
                    Object lastRd = lastRegisterObject.get(connectionName);
                    if (lastRd == null) continue;
                    LeakedContextRef<ServiceConnection> ref = new LeakedContextRef<ServiceConnection>(contextName, rd, lastRd, connection);
                    leakedObjects.put(connectionName, ref);
                    continue;
                }
                lastRegisterObject.put(connectionName, rd);
                registerCount.put(connectionName, 1);
            }
            for (Map.Entry entry : leakedObjects.entrySet()) {
                LeakedContextRef ref;
                String key = (String)entry.getKey();
                Integer count = (Integer)registerCount.get(key);
                if (count == null || (ref = (LeakedContextRef)leakedObjects.get(key)) == null) continue;
                this.servicesRdLeaked(ref, count);
            }
        }
    }

    private void servicesRdLeaked(LeakedContextRef<ServiceConnection> ref, int count) {
        ServiceConnection leakedObject = ref.getLeakedContext();
        String leakedName = leakedObject.getClass().getName();
        if (this.mHasLeakedServices.contains(leakedName)) {
            return;
        }
        this.mHasLeakedServices.add(leakedName);
        String contextName = ref.getContextName();
        Object rd = ref.getCurrentLeakedObject();
        Object lastRd = ref.getLastLeakedObject();
        String info = "Bind instances=" + count + " " + contextName + "/" + leakedName + " has leaked ServiceConnection originally bind here. Are you missing a call to unbindService()?";
        Throwable cause = (Throwable)ObjectInvoker.wrap(lastRd).get("mLocation").toObject();
        Throwable self = (Throwable)ObjectInvoker.wrap(rd).get("mLocation").toObject();
        MultiServiceViolation leak = new MultiServiceViolation(info, cause);
        leak.setStackTrace(self.getStackTrace());
        OlympicPerformanceMode.onMultiBindService(this.buildError(info, leak));
    }

    private Runnable createCheckTask() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (!MultiServicePluginImpl.this.mHasException) {
                        MultiServicePluginImpl.this.doCheck();
                    }
                }
                catch (Exception e) {
                    MultiServicePluginImpl.this.mHasException = true;
                }
            }
        };
    }
}

