/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.preferences;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.taobao.monitor.olympic.OlympicPerformanceMode;
import com.taobao.monitor.olympic.plugins.preferences.ContextWrapperProxy;
import com.taobao.monitor.olympic.utils.ObjectInvoker;

public class SharedPreferencesHook {
    @TargetApi(value=14)
    public void startHook(Application application) {
        application.registerActivityLifecycleCallbacks(this.createLifecycle());
    }

    @TargetApi(value=14)
    private Application.ActivityLifecycleCallbacks createLifecycle() {
        return new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                if (!OlympicPerformanceMode.detectBadSharedPreferencesHostEnabled()) {
                    return;
                }
                try {
                    ObjectInvoker activityInvoker = ObjectInvoker.wrap(activity);
                    Context oldContext = (Context)activityInvoker.get("mBase").toObject();
                    activityInvoker.set("mBase", (Object)new ContextWrapperProxy(oldContext, (Context)activity));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        };
    }
}

