/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.preferences;

import android.content.SharedPreferences;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.taobao.monitor.olympic.OlympicPerformanceMode;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.plugins.preferences.BadSharedPreferencesViolation;
import com.taobao.monitor.olympic.plugins.preferences.SPLongCostViolation;
import com.taobao.monitor.olympic.utils.ThreadUtils;
import java.util.Map;
import java.util.Set;

public class SharedPreferencesWrapper
implements SharedPreferences {
    private final SharedPreferences mSharedPreferences;
    private final boolean isApplicationHost;
    private final String name;

    public SharedPreferencesWrapper(SharedPreferences sharedPreferences, boolean isApplicationHost, String name) {
        this.mSharedPreferences = sharedPreferences;
        this.isApplicationHost = isApplicationHost;
        this.name = name;
    }

    public Map<String, ?> getAll() {
        return this.mSharedPreferences.getAll();
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        return this.mSharedPreferences.getString(key, defValue);
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        return this.mSharedPreferences.getStringSet(key, defValues);
    }

    public int getInt(String key, int defValue) {
        return this.mSharedPreferences.getInt(key, defValue);
    }

    public long getLong(String key, long defValue) {
        return this.mSharedPreferences.getLong(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        return this.mSharedPreferences.getFloat(key, defValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.mSharedPreferences.getBoolean(key, defValue);
    }

    public boolean contains(String key) {
        return this.mSharedPreferences.contains(key);
    }

    public SharedPreferences.Editor edit() {
        return new EditImplWrapper(this.mSharedPreferences.edit(), this.mSharedPreferences, this.isApplicationHost, this.name);
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mSharedPreferences.registerOnSharedPreferenceChangeListener(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mSharedPreferences.unregisterOnSharedPreferenceChangeListener(listener);
    }

    private static class EditImplWrapper
    implements SharedPreferences.Editor {
        final SharedPreferences.Editor editor;
        final SharedPreferences sharedPreferences;
        private final boolean isApplicationHost;
        private final String name;

        public EditImplWrapper(SharedPreferences.Editor editor, SharedPreferences sharedPreferences, boolean isApplicationHost, String name) {
            this.editor = editor;
            this.sharedPreferences = sharedPreferences;
            this.isApplicationHost = isApplicationHost;
            this.name = name;
        }

        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            return this.editor.putString(key, value);
        }

        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            return this.editor.putStringSet(key, values);
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            return this.editor.putInt(key, value);
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            return this.editor.putLong(key, value);
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            return this.editor.putFloat(key, value);
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            return this.editor.putBoolean(key, value);
        }

        public SharedPreferences.Editor remove(String key) {
            return this.editor.remove(key);
        }

        public SharedPreferences.Editor clear() {
            return this.editor.clear();
        }

        public boolean commit() {
            if (OlympicPerformanceMode.detectBadSharedPreferencesActionEnabled() && ThreadUtils.isMainThread(Thread.currentThread())) {
                long startTime = SystemClock.uptimeMillis();
                boolean result = this.editor.commit();
                long endTime = SystemClock.uptimeMillis();
                if (endTime - startTime > 1000L) {
                    ViolationError error = this.createError(new SPLongCostViolation(endTime - startTime));
                    OlympicPerformanceMode.onBadSharedPreferencesAction(error);
                }
                return result;
            }
            return this.editor.commit();
        }

        public void apply() {
            if (OlympicPerformanceMode.detectBadSharedPreferencesHostEnabled() && !this.isApplicationHost) {
                ViolationError error = this.createError(new BadSharedPreferencesViolation(this.name + ":\u67b6\u6784\u7ec4\u4f18\u5316\u4e86application.getSharedPreferences()\u7684\u6027\u80fd\uff0c\u80fd\u51cf\u5c11sharedPreferences.apply\u5bfc\u81f4\u7684ANR"));
                OlympicPerformanceMode.onBadSharedPreferencesHost(error);
            }
            this.asyncCommit();
        }

        private void asyncCommit() {
            Global.instance().executor().execute(new InnerRunnable());
        }

        private ViolationError createError(Throwable throwable) {
            ViolationError.Builder builder = new ViolationError.Builder("HA_MAIN_THREAD_BLOCK");
            builder.setThrowable(throwable);
            builder.setMessage(this.name + ":\u67b6\u6784\u7ec4\u4f18\u5316\u4e86application.getSharedPreferences()\u7684\u6027\u80fd\uff0c\u80fd\u51cf\u5c11sharedPreferences.apply\u5bfc\u81f4\u7684ANR");
            builder.setPolicy(-1);
            return builder.build();
        }

        private class InnerRunnable
        implements Runnable {
            private InnerRunnable() {
            }

            @Override
            public void run() {
                EditImplWrapper.this.editor.commit();
            }
        }
    }
}

