/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.strictmode;

import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.plugins.strictmode.tranfer.TransferProxy;
import java.util.concurrent.Executor;

public class ViolationSubject {
    private final TransferProxy mTransfer = new TransferProxy();
    private Observer mObserver;
    private Executor mExecutor;

    private ViolationSubject() {
    }

    public static ViolationSubject instance() {
        return Holder.INSTANCE;
    }

    public void setObserver(Observer observer) {
        this.mObserver = observer;
    }

    public void setExecutor(Executor executor) {
        this.mExecutor = executor;
    }

    public void notifyViolation(final Object info) {
        final Observer observer = this.mObserver;
        if (observer != null) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    ViolationError error = ViolationSubject.this.mTransfer.transfer(info);
                    Logger.i("ViolationSubject", error);
                    if (error != null) {
                        observer.onViolation(error);
                    }
                }
            });
        }
    }

    public void notifyViolation(final ViolationError error) {
        Logger.i("ViolationSubject", error);
        final Observer observer = this.mObserver;
        if (error != null && observer != null) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    observer.onViolation(error);
                }
            });
        }
    }

    private void execute(Runnable runnable) {
        Executor executor = this.mExecutor;
        if (executor == null) {
            runnable.run();
        } else {
            executor.execute(runnable);
        }
    }

    private static class Holder {
        private static ViolationSubject INSTANCE = new ViolationSubject();

        private Holder() {
        }
    }

    public static interface Observer {
        public void onViolation(ViolationError var1);
    }
}

