/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.strictmode.tranfer;

import android.annotation.TargetApi;
import android.text.TextUtils;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.Transfer;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.utils.ObjectInvoker;

@TargetApi(value=23)
public class ViolationInfoTransfer23
implements Transfer<Object, ViolationError> {
    @Override
    public ViolationError transfer(Object from) {
        ObjectInvoker fromInvoker = ObjectInvoker.wrap(from);
        ObjectInvoker crashInfoInvoker = fromInvoker.get("crashInfo");
        String stackTrace = (String)crashInfoInvoker.get("stackTrace").toObject();
        if (stackTrace.startsWith("java.lang.Throwable: Detected cleartext network traffic from UID ")) {
            stackTrace = this.replaceUid(stackTrace);
        }
        ViolationError.Builder builder = new ViolationError.Builder(this.violation2Type(stackTrace));
        builder.setPolicy((Integer)fromInvoker.get("policy").toObject());
        builder.setMessage((String)fromInvoker.get("message").toObject());
        builder.setStackTrace(stackTrace);
        String exceptionMessage = (String)crashInfoInvoker.get("exceptionMessage").toObject();
        if (!TextUtils.isEmpty((CharSequence)exceptionMessage) && exceptionMessage.startsWith("Detected cleartext network traffic from")) {
            exceptionMessage = this.replaceUid(exceptionMessage);
        }
        builder.setExceptionMessage(exceptionMessage);
        return builder.build();
    }

    private String violation2Type(String stackTrace) {
        if (TextUtils.isEmpty((CharSequence)stackTrace)) {
            return "UNKNOWN";
        }
        String shortStackTrace = this.shortStackTrace(stackTrace);
        Logger.i("Transfer", stackTrace);
        if (shortStackTrace.startsWith("android.os.StrictMode$StrictModeCustomViolation") || shortStackTrace.startsWith("android.os.StrictMode$StrictModeDiskReadViolation") || shortStackTrace.startsWith("android.os.StrictMode$StrictModeDiskWriteViolation") || shortStackTrace.startsWith("android.os.StrictMode$StrictModeNetworkViolation") || shortStackTrace.startsWith("android.os.StrictMode$LogStackTrace") || shortStackTrace.startsWith("android.os.StrictMode$StrictModeUnbufferedIOViolation")) {
            return "HA_MAIN_THREAD_IO";
        }
        if (shortStackTrace.startsWith("android.app.ServiceConnectionLeaked") || shortStackTrace.startsWith("android.app.IntentReceiverLeaked") || shortStackTrace.startsWith("android.os.StrictMode$InstanceCountViolation")) {
            return "HA_MEM_LEAK";
        }
        if (stackTrace.contains("dalvik.system.CloseGuard.open") || shortStackTrace.startsWith("android.database.sqlite.DatabaseObjectNotClosedException")) {
            return "HA_RESOURCE_LEAK";
        }
        if (stackTrace.contains("android.os.StrictMode.onFileUriExposed") || stackTrace.contains("android.os.StrictMode.onCleartextNetworkDetected") || stackTrace.contains("android.os.StrictMode.onContentUriWithoutPermission") || shortStackTrace.startsWith("android.os.StrictMode$StrictModeResourceMismatchViolation") || stackTrace.contains("android.os.StrictMode.onUntaggedSocket")) {
            return "HA_SECURITY_GUARD";
        }
        return "HA_SECURITY_GUARD";
    }

    private String shortStackTrace(String stackTrace) {
        int index = stackTrace.indexOf(":");
        if (index != -1) {
            return stackTrace.substring(0, index);
        }
        return stackTrace;
    }

    private String replaceUid(String uidString) {
        int index = uidString.indexOf("UID");
        if (index != -1) {
            try {
                return uidString.substring(0, index - 1) + " UID XXXXX " + uidString.substring(index + 9);
            }
            catch (Exception e) {
                Logger.throwException(e);
            }
        }
        return uidString;
    }
}

