/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.strictmode.tranfer;

import android.annotation.TargetApi;
import android.os.strictmode.CleartextNetworkViolation;
import android.os.strictmode.ContentUriWithoutPermissionViolation;
import android.os.strictmode.CustomViolation;
import android.os.strictmode.DiskReadViolation;
import android.os.strictmode.DiskWriteViolation;
import android.os.strictmode.FileUriExposedViolation;
import android.os.strictmode.InstanceCountViolation;
import android.os.strictmode.IntentReceiverLeakedViolation;
import android.os.strictmode.LeakedClosableViolation;
import android.os.strictmode.NetworkViolation;
import android.os.strictmode.NonSdkApiUsedViolation;
import android.os.strictmode.ResourceMismatchViolation;
import android.os.strictmode.ServiceConnectionLeakedViolation;
import android.os.strictmode.SqliteObjectLeakedViolation;
import android.os.strictmode.UnbufferedIoViolation;
import android.os.strictmode.UntaggedSocketViolation;
import android.os.strictmode.WebViewMethodCalledOnWrongThreadViolation;
import android.text.TextUtils;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.plugins.strictmode.tranfer.ViolationErrorTransfer;
import com.taobao.monitor.olympic.utils.ObjectInvoker;

@TargetApi(value=28)
public class ViolationInfoTransfer28
implements ViolationErrorTransfer {
    @Override
    public ViolationError transfer(Object from) {
        ObjectInvoker fromInvoker = ObjectInvoker.wrap(from);
        Throwable throwable = (Throwable)fromInvoker.get("mViolation").toObject();
        ViolationError.Builder builder = new ViolationError.Builder(this.violation2Type(throwable));
        builder.setPolicy((Integer)fromInvoker.get("mPolicy").toObject());
        String stackTrace = (String)fromInvoker.get("mStackTrace").toObject();
        if (TextUtils.isEmpty((CharSequence)stackTrace)) {
            builder.setStackTrace((String)fromInvoker.invoke("getStackTrace", new Object[0]).toObject());
        } else {
            builder.setStackTrace(stackTrace);
        }
        builder.setThrowable(throwable);
        return builder.build();
    }

    private String violation2Type(Throwable violation) {
        if (violation instanceof CustomViolation || violation instanceof DiskWriteViolation || violation instanceof DiskReadViolation || violation instanceof NetworkViolation || violation instanceof UnbufferedIoViolation) {
            return "HA_MAIN_THREAD_IO";
        }
        if (violation instanceof IntentReceiverLeakedViolation || violation instanceof ServiceConnectionLeakedViolation || violation instanceof InstanceCountViolation) {
            return "HA_MEM_LEAK";
        }
        if (violation instanceof LeakedClosableViolation || violation instanceof SqliteObjectLeakedViolation) {
            return "HA_RESOURCE_LEAK";
        }
        if (violation instanceof FileUriExposedViolation || violation instanceof CleartextNetworkViolation || violation instanceof ContentUriWithoutPermissionViolation || violation instanceof NonSdkApiUsedViolation || violation instanceof ResourceMismatchViolation || violation instanceof UntaggedSocketViolation || violation instanceof WebViewMethodCalledOnWrongThreadViolation) {
            return "HA_SECURITY_GUARD";
        }
        return "HA_SECURITY_GUARD";
    }
}

