/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.strictmode.tranfer;

import android.annotation.TargetApi;
import android.os.strictmode.CleartextNetworkViolation;
import android.os.strictmode.ContentUriWithoutPermissionViolation;
import android.os.strictmode.CustomViolation;
import android.os.strictmode.DiskReadViolation;
import android.os.strictmode.DiskWriteViolation;
import android.os.strictmode.FileUriExposedViolation;
import android.os.strictmode.InstanceCountViolation;
import android.os.strictmode.IntentReceiverLeakedViolation;
import android.os.strictmode.LeakedClosableViolation;
import android.os.strictmode.NetworkViolation;
import android.os.strictmode.NonSdkApiUsedViolation;
import android.os.strictmode.ResourceMismatchViolation;
import android.os.strictmode.ServiceConnectionLeakedViolation;
import android.os.strictmode.SqliteObjectLeakedViolation;
import android.os.strictmode.UnbufferedIoViolation;
import android.os.strictmode.UntaggedSocketViolation;
import android.os.strictmode.WebViewMethodCalledOnWrongThreadViolation;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.Transfer;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.utils.ObjectInvoker;

@TargetApi(value=28)
public class ViolationTransfer28
implements Transfer<Throwable, ViolationError> {
    @Override
    public ViolationError transfer(Throwable throwable) {
        ViolationError.Builder builder = new ViolationError.Builder(this.violation2Type(throwable));
        if (throwable instanceof CleartextNetworkViolation) {
            String message = throwable.getMessage();
            int index = message.indexOf("UID");
            if (index != -1) {
                try {
                    message = message.substring(0, index - 1) + " UID XXXXX " + message.substring(index + 9);
                }
                catch (Exception e) {
                    Logger.throwException(e);
                }
            }
            ObjectInvoker.wrap(throwable).set("detailMessage", (Object)message);
        }
        builder.setThrowable(throwable);
        return builder.build();
    }

    private String violation2Type(Throwable violation) {
        if (violation instanceof CustomViolation || violation instanceof DiskWriteViolation || violation instanceof DiskReadViolation || violation instanceof NetworkViolation || violation instanceof UnbufferedIoViolation) {
            return "HA_MAIN_THREAD_IO";
        }
        if (violation instanceof IntentReceiverLeakedViolation || violation instanceof ServiceConnectionLeakedViolation || violation instanceof InstanceCountViolation) {
            return "HA_MEM_LEAK";
        }
        if (violation instanceof LeakedClosableViolation || violation instanceof SqliteObjectLeakedViolation) {
            return "HA_RESOURCE_LEAK";
        }
        if (violation instanceof FileUriExposedViolation || violation instanceof CleartextNetworkViolation || violation instanceof ContentUriWithoutPermissionViolation || violation instanceof NonSdkApiUsedViolation || violation instanceof ResourceMismatchViolation || violation instanceof UntaggedSocketViolation || violation instanceof WebViewMethodCalledOnWrongThreadViolation) {
            return "HA_SECURITY_GUARD";
        }
        return "HA_SECURITY_GUARD";
    }
}

