/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.plugins.wakelock;

import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;
import com.taobao.monitor.olympic.plugins.wakelock.WakeLockViolation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class PowerManagerProxy
implements InvocationHandler {
    private final Object real;

    PowerManagerProxy(Object real) {
        this.real = real;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("acquireWakeLock")) {
            try {
                ViolationSubject.instance().notifyViolation(this.createError());
            }
            catch (Throwable e) {
                Logger.throwException(e);
            }
        }
        try {
            return method.invoke(this.real, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private ViolationError createError() {
        ViolationError.Builder builder = new ViolationError.Builder("HA_CPU_OVER_OCCUPY");
        builder.setThrowable(new WakeLockViolation("wake lock \u8c03\u7528"));
        builder.setMessage("\u8c01\u5728\u8c03\u7528WakeLock");
        builder.setPolicy(-1);
        return builder.build();
    }
}

