/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.sender;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import com.alibaba.ha.bizerrorreporter.BizErrorReporter;
import com.alibaba.ha.bizerrorreporter.module.AggregationType;
import com.alibaba.ha.bizerrorreporter.module.BizErrorModule;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;

public class TBSender
implements ViolationSubject.Observer {
    @Override
    public void onViolation(ViolationError error) {
        Context context = Global.instance().context();
        BizErrorModule bizError = this.violation2BizError(error);
        BizErrorReporter.getInstance().send(context, bizError);
    }

    private BizErrorModule violation2BizError(ViolationError error) {
        BizErrorModule bizError = new BizErrorModule();
        bizError.businessType = error.getType();
        Throwable throwable = error.getThrowable();
        String stackTrace = error.getStackTrace();
        bizError.aggregationType = throwable == null && TextUtils.isEmpty((CharSequence)stackTrace) ? AggregationType.CONTENT : AggregationType.STACK;
        bizError.exceptionId = bizError.businessType + SystemClock.uptimeMillis();
        bizError.exceptionCode = this.createKey(error);
        if (throwable == null) {
            bizError.exceptionDetail = this.createDetail(error);
        }
        bizError.throwable = throwable;
        bizError.thread = null;
        bizError.exceptionVersion = "1.0.0";
        bizError.exceptionArg1 = "arg1";
        bizError.exceptionArg2 = "arg2";
        bizError.exceptionArg3 = "arg3";
        return bizError;
    }

    private String createKey(ViolationError error) {
        int index;
        String message = error.getExceptionMessage();
        if (message != null && (index = message.indexOf("UID")) != -1) {
            try {
                message = message.substring(0, index - 1) + " UID XXXXX " + message.substring(index + 9);
            }
            catch (Exception e) {
                Logger.throwException(e);
            }
        }
        return message;
    }

    private String createDetail(ViolationError error) {
        String stackTrace = error.getStackTrace();
        return TextUtils.isEmpty((CharSequence)stackTrace) ? error.getMessage() : stackTrace;
    }
}

