/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ObjectInvoker {
    private final Object mObject;
    private final Class mObjectClass;

    public static ObjectInvoker wrap(Object object) {
        return new ObjectInvoker(object);
    }

    public static ObjectInvoker create(Class clazz, Object ... params) {
        try {
            Constructor constructor = ObjectInvoker.getConstructor(clazz, params);
            constructor.setAccessible(true);
            return new ObjectInvoker(constructor.newInstance(params));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectInvoker(Object mObject) {
        this.mObject = mObject;
        this.mObjectClass = mObject instanceof Class ? (Class)mObject : (mObject != null ? mObject.getClass() : NullPointerException.class);
    }

    public <T> T toObject() {
        return (T)this.mObject;
    }

    public ObjectInvoker get(String fieldName) throws RuntimeException {
        try {
            return this.get(this.getField(fieldName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Field getField(String fieldName) throws RuntimeException {
        Class c = this.mObjectClass;
        Field field = null;
        while (true) {
            try {
                field = c.getDeclaredField(fieldName);
            }
            catch (Exception exception) {
                if ((c = c.getSuperclass()) != Object.class) continue;
            }
            break;
        }
        if (field == null) {
            throw new RuntimeException(new NoSuchFieldException());
        }
        return field;
    }

    public ObjectInvoker get(String fieldName, Class clz) throws RuntimeException {
        try {
            Field field = clz.getDeclaredField(fieldName);
            return this.get(field);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectInvoker invoke(String methodName, Object ... args) throws RuntimeException {
        Method method = this.getMethod(methodName, args);
        method.setAccessible(true);
        ObjectInvoker ret = null;
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        try {
            if (!isStatic) {
                if (method.getReturnType() != Void.TYPE) {
                    ret = new ObjectInvoker(method.invoke(this.mObject, args));
                } else {
                    method.invoke(this.mObject, args);
                }
            } else if (method.getReturnType() != Void.TYPE) {
                ret = new ObjectInvoker(method.invoke(null, args));
            } else {
                method.invoke(null, args);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ObjectInvoker set(String fieldName, Object o) throws RuntimeException {
        return this.set(this.getField(fieldName), o);
    }

    public ObjectInvoker set(String fieldName, Class clz, Object o) throws Exception {
        Field field = clz.getDeclaredField(fieldName);
        return this.set(field, o);
    }

    private ObjectInvoker get(Field field) throws Exception {
        field.setAccessible(true);
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        return new ObjectInvoker(isStatic ? field.get(null) : field.get(this.mObject));
    }

    private ObjectInvoker set(Field field, Object o) throws RuntimeException {
        try {
            field.setAccessible(true);
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (isStatic) {
                field.set(null, o);
            } else {
                field.set(this.mObject, o);
            }
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Method getMethod(String methodName, Object ... args) {
        int length = args != null ? args.length : 0;
        List<Method> methods = this.getMethodsByName(methodName, length);
        for (Method method : methods) {
            Class<?>[] classes = method.getParameterTypes();
            if (classes.length != length) continue;
            boolean isTarget = true;
            for (int i = 0; i < classes.length; ++i) {
                if (ObjectInvoker.isClassObject(args[i], classes[i])) continue;
                isTarget = false;
                break;
            }
            if (!isTarget) continue;
            return method;
        }
        throw new RuntimeException();
    }

    private static Constructor getConstructor(Class klass, Object ... args) {
        int length = args != null ? args.length : 0;
        List<Constructor> Constructors = ObjectInvoker.getConstructors(klass, length);
        for (Constructor constructor : Constructors) {
            Class<?>[] classes = constructor.getParameterTypes();
            if (classes.length != length) continue;
            boolean isTarget = true;
            for (int i = 0; i < classes.length; ++i) {
                if (ObjectInvoker.isClassObject(args[i], classes[i])) continue;
                isTarget = false;
                break;
            }
            if (!isTarget) continue;
            return constructor;
        }
        throw new RuntimeException();
    }

    private static boolean isClassObject(Object o, Class objectClass) {
        if (o == null) {
            return true;
        }
        if (o.getClass() == Boolean.class && objectClass == Boolean.TYPE) {
            return true;
        }
        if (o.getClass() == Byte.class && objectClass == Byte.TYPE) {
            return true;
        }
        if (o.getClass() == Character.class && objectClass == Character.TYPE) {
            return true;
        }
        if (o.getClass() == Short.class && objectClass == Short.TYPE) {
            return true;
        }
        if (o.getClass() == Integer.class && objectClass == Integer.TYPE) {
            return true;
        }
        if (o.getClass() == Float.class && objectClass == Float.TYPE) {
            return true;
        }
        if (o.getClass() == Long.class && objectClass == Long.TYPE) {
            return true;
        }
        if (o.getClass() == Double.class && objectClass == Double.TYPE) {
            return true;
        }
        return objectClass.isInstance(o);
    }

    private List<Method> getMethodsByName(String methodName, int argsLength) {
        ArrayList<Method> list = new ArrayList<Method>();
        Class c = this.mObjectClass;
        do {
            Method[] methods;
            if ((methods = c.getDeclaredMethods()) == null) continue;
            for (Method method : methods) {
                if (method == null || !method.getName().equals(methodName) || method.getParameterTypes().length != argsLength) continue;
                list.add(method);
            }
        } while ((c = c.getSuperclass()) != Object.class);
        return list;
    }

    private static List<Constructor> getConstructors(Class klass, int argsLength) {
        Constructor<?>[] constructors;
        ArrayList<Constructor> list = new ArrayList<Constructor>();
        for (Constructor<?> constructor : constructors = klass.getConstructors()) {
            if (constructor.getParameterTypes().length != argsLength) continue;
            list.add(constructor);
        }
        return list;
    }
}

