/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.motu.tbrest.request;

import android.text.TextUtils;
import com.alibaba.motu.tbrest.SendService;
import com.alibaba.motu.tbrest.request.BizRequest;
import com.alibaba.motu.tbrest.request.BizResponse;
import com.alibaba.motu.tbrest.request.RestSslSocketFactory;
import com.alibaba.motu.tbrest.sign.RestBaseRequestAuthentication;
import com.alibaba.motu.tbrest.utils.LogUtil;
import com.alibaba.motu.tbrest.utils.MD5Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;

public class UrlWrapper {
    private static final int MAX_CONNECTION_TIME_OUT = 10000;
    private static final int MAX_READ_CONNECTION_STREAM_TIME_OUT = 60000;
    public static int mErrorCode = 0;
    private static RestSslSocketFactory mRestSslSocketFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BizResponse sendRequest(String appkey, String adashUrl, byte[] bytes) {
        HttpURLConnection conn;
        LogUtil.d("sendRequest use adashx, bytes length : " + (bytes == null ? "0" : Integer.valueOf(bytes.length)));
        BizResponse bizResponse = new BizResponse();
        try {
            URL url = SendService.getInstance().openHttp != false ? new URL(adashUrl) : new URL(adashUrl);
            conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                try {
                    if (mRestSslSocketFactory == null && !TextUtils.isEmpty((CharSequence)url.getHost())) {
                        mRestSslSocketFactory = new RestSslSocketFactory(url.getHost());
                    }
                    ((HttpsURLConnection)conn).setSSLSocketFactory(mRestSslSocketFactory);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        catch (MalformedURLException e1) {
            return bizResponse;
        }
        catch (IOException e2) {
            return bizResponse;
        }
        if (conn != null) {
            conn.setDoOutput(true);
            conn.setDoInput(true);
            try {
                conn.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                return bizResponse;
            }
            conn.setUseCaches(false);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(60000);
            conn.setInstanceFollowRedirects(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Charset", "UTF-8");
            if (!TextUtils.isEmpty((CharSequence)appkey)) {
                conn.setRequestProperty("x-k", appkey);
            }
            try {
                String appSecret = SendService.getInstance().appSecret;
                if (appSecret != null && appSecret.length() > 0) {
                    RestBaseRequestAuthentication requestAuthentication = new RestBaseRequestAuthentication(appkey, appSecret, true);
                    String signValue = requestAuthentication.getSign(MD5Utils.getMd5Hex(bytes));
                    LogUtil.d("signValue:" + signValue);
                    conn.setRequestProperty("x-s", signValue);
                    conn.setRequestProperty("x-t", "2");
                } else {
                    String secret = "";
                    RestBaseRequestAuthentication requestAuthentication = new RestBaseRequestAuthentication(appkey, secret, false);
                    String signValue = requestAuthentication.getSign(MD5Utils.getMd5Hex(bytes));
                    LogUtil.d("signValue:" + signValue);
                    conn.setRequestProperty("x-s", signValue);
                    conn.setRequestProperty("x-t", "3");
                }
            }
            catch (Throwable e) {
                LogUtil.e(e.toString());
            }
            long now = System.currentTimeMillis();
            FilterOutputStream out = null;
            try {
                conn.connect();
                if (bytes != null && bytes.length > 0) {
                    out = new DataOutputStream(conn.getOutputStream());
                    out.write(bytes);
                    ((DataOutputStream)out).flush();
                }
            }
            catch (SSLHandshakeException e) {
                LogUtil.e(e.toString());
                bizResponse.rt = System.currentTimeMillis() - now;
                BizResponse bizResponse2 = bizResponse;
                return bizResponse2;
            }
            catch (Exception e) {
                LogUtil.e(e.toString());
                bizResponse.rt = System.currentTimeMillis() - now;
                BizResponse bizResponse3 = bizResponse;
                return bizResponse3;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LogUtil.e(e.toString());
                    }
                }
            }
            bizResponse.rt = System.currentTimeMillis() - now;
            DataInputStream dis = null;
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            try {
                int i;
                dis = new DataInputStream(conn.getInputStream());
                byte[] buffer = new byte[2048];
                while ((i = ((InputStream)dis).read(buffer, 0, 2048)) != -1) {
                    bs.write(buffer, 0, i);
                }
            }
            catch (IOException e) {
                LogUtil.e(e.toString());
            }
            finally {
                if (dis != null) {
                    try {
                        ((InputStream)dis).close();
                    }
                    catch (Exception e) {
                        LogUtil.e(e.toString());
                    }
                }
            }
            if (bs.size() > 0) {
                bizResponse.errCode = mErrorCode = BizRequest.parseResult(bs.toByteArray());
                bizResponse.data = BizRequest.mResponseAdditionalData;
            }
        }
        return bizResponse;
    }

    public static BizResponse sendRequest(String adashxHost, byte[] bytes) {
        String appkey = SendService.getInstance().appKey;
        String adashUrl = null;
        adashUrl = SendService.getInstance().openHttp != false ? "http://" + adashxHost + "/upload" : "https://" + adashxHost + "/upload";
        return UrlWrapper.sendRequest(appkey, adashUrl, bytes);
    }

    public static BizResponse sendRequestByUrl(String url, byte[] bytes) {
        String appkey = SendService.getInstance().appKey;
        return UrlWrapper.sendRequest(appkey, url, bytes);
    }

    static {
        System.setProperty("http.keepAlive", "true");
    }
}

