/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.motu.tbrest.rest;

import com.alibaba.motu.tbrest.rest.RestKeyArraySorter;
import com.alibaba.motu.tbrest.utils.LogUtil;
import com.alibaba.motu.tbrest.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class RestHttpUtils {
    private static final String POST_Field_TOP = "--GJircTeP\r\nContent-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\nContent-Type: application/octet-stream \r\n\r\n";
    private static final String POST_Field_BOTTOM = "--GJircTeP--\r\n";
    public static final int HTTP_REQ_TYPE_GET = 1;
    public static final int HTTP_REQ_TYPE_POST_FORM_DATA = 2;
    public static final int HTTP_REQ_TYPE_POST_URL_ENCODED = 3;
    public static final int MAX_CONNECTION_TIME_OUT = 10000;
    public static final int MAX_READ_CONNECTION_STREAM_TIME_OUT = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sendRequest(int requestType, String aUrl, Map<String, Object> pMap, boolean openGzip) {
        HttpURLConnection conn;
        if (StringUtils.isEmpty(aUrl)) {
            return null;
        }
        try {
            URL url = new URL(aUrl);
            conn = (HttpURLConnection)url.openConnection();
        }
        catch (MalformedURLException e) {
            LogUtil.e("connection error!", e);
            return null;
        }
        catch (IOException e) {
            LogUtil.e("connection error!", e);
            return null;
        }
        if (conn != null) {
            Set<String> keys;
            if (requestType == 2 || requestType == 3) {
                conn.setDoOutput(true);
            }
            conn.setDoInput(true);
            try {
                if (requestType == 2 || requestType == 3) {
                    conn.setRequestMethod("POST");
                } else {
                    conn.setRequestMethod("GET");
                }
            }
            catch (ProtocolException e) {
                LogUtil.e("connection error!", e);
                return null;
            }
            conn.setUseCaches(false);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(60000);
            conn.setRequestProperty("Connection", "close");
            if (openGzip) {
                conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            }
            conn.setInstanceFollowRedirects(true);
            byte[] data = null;
            if (requestType == 2 || requestType == 3) {
                if (requestType == 2) {
                    conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=GJircTeP");
                } else if (requestType == 3) {
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                }
                int contentLength = 0;
                if (null != pMap && pMap.size() > 0) {
                    ByteArrayOutputStream lBaos = new ByteArrayOutputStream();
                    keys = pMap.keySet();
                    String[] lKeysArr = new String[keys.size()];
                    keys.toArray(lKeysArr);
                    for (String key : lKeysArr = RestKeyArraySorter.getInstance().sortResourcesList(lKeysArr, true)) {
                        Object lValue;
                        if (requestType == 2) {
                            lValue = (byte[])pMap.get(key);
                            if (null == lValue) continue;
                            try {
                                lBaos.write(String.format(POST_Field_TOP, key, key).getBytes());
                                lBaos.write((byte[])lValue);
                                lBaos.write("\r\n".getBytes());
                            }
                            catch (IOException e) {
                                LogUtil.e("write lBaos error!", e);
                            }
                            continue;
                        }
                        if (requestType != 3) continue;
                        lValue = (String)pMap.get(key);
                        if (lBaos.size() > 0) {
                            try {
                                lBaos.write(("&" + key + "=" + (String)lValue).getBytes());
                            }
                            catch (IOException e) {
                                LogUtil.e("write lBaos error!", e);
                            }
                            continue;
                        }
                        try {
                            lBaos.write((key + "=" + (String)lValue).getBytes());
                        }
                        catch (IOException e) {
                            LogUtil.e("write lBaos error!", e);
                        }
                    }
                    try {
                        if (requestType == 2) {
                            lBaos.write(POST_Field_BOTTOM.getBytes());
                        }
                    }
                    catch (IOException e) {
                        LogUtil.e("write lBaos error!", e);
                    }
                    data = lBaos.toByteArray();
                }
                if (data != null) {
                    contentLength = data.length;
                }
                conn.setRequestProperty("Content-Length", String.valueOf(contentLength));
            }
            FilterOutputStream out = null;
            try {
                conn.connect();
                if ((requestType == 2 || requestType == 3) && data != null && data.length > 0) {
                    out = new DataOutputStream(conn.getOutputStream());
                    out.write(data);
                    ((DataOutputStream)out).flush();
                }
            }
            catch (Exception e) {
                LogUtil.e("write out error!", e);
                keys = null;
                return keys;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LogUtil.e("out close error!", e);
                    }
                }
            }
            InputStream dis = null;
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            try {
                int i;
                dis = openGzip && "gzip".equals(conn.getContentEncoding()) ? new GZIPInputStream(conn.getInputStream()) : new DataInputStream(conn.getInputStream());
                byte[] buffer = new byte[2048];
                while ((i = dis.read(buffer, 0, 2048)) != -1) {
                    bs.write(buffer, 0, i);
                }
            }
            catch (IOException e) {
                LogUtil.e("write out error!", e);
                String[] stringArray = null;
                return stringArray;
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (Exception e) {
                        LogUtil.e("out close error!", e);
                    }
                }
            }
            if (bs.size() > 0) {
                return bs.toByteArray();
            }
            return null;
        }
        return null;
    }
}

