/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.motu.tbrest.rest;

import com.alibaba.motu.tbrest.utils.StringUtils;
import java.util.Arrays;
import java.util.Comparator;

public class RestKeyArraySorter {
    private static RestKeyArraySorter s_instance = null;
    private ResourcesDESCComparator mDESCComparator = new ResourcesDESCComparator();
    private ResourcesASCComparator mASCComparator = new ResourcesASCComparator();

    private RestKeyArraySorter() {
    }

    public static synchronized RestKeyArraySorter getInstance() {
        if (null == s_instance) {
            s_instance = new RestKeyArraySorter();
        }
        return s_instance;
    }

    public String[] sortResourcesList(String[] resources, boolean aUseASC) {
        Comparator<String> lCompare = null;
        lCompare = aUseASC ? this.mASCComparator : this.mDESCComparator;
        if (null != lCompare && resources != null && resources.length > 0) {
            Arrays.sort(resources, lCompare);
            return resources;
        }
        return null;
    }

    private class ResourcesASCComparator
    implements Comparator<String> {
        private ResourcesASCComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (!StringUtils.isEmpty(o1) && !StringUtils.isEmpty(o2)) {
                return o1.compareTo(o2);
            }
            return 0;
        }
    }

    private class ResourcesDESCComparator
    implements Comparator<String> {
        private ResourcesDESCComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (!StringUtils.isEmpty(o1) && !StringUtils.isEmpty(o2)) {
                int i = o1.compareTo(o2);
                return -1 * i;
            }
            return 0;
        }
    }
}

