/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.motu.tbrest.rest;

import android.content.Context;
import android.os.Build;
import com.alibaba.motu.tbrest.SendService;
import com.alibaba.motu.tbrest.rest.RestFieldsScheme;
import com.alibaba.motu.tbrest.rest.RestReqDataBuildResult;
import com.alibaba.motu.tbrest.rest.RestUrlWrapper;
import com.alibaba.motu.tbrest.utils.DeviceUtils;
import com.alibaba.motu.tbrest.utils.LogUtil;
import com.alibaba.motu.tbrest.utils.RC4;
import com.alibaba.motu.tbrest.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class RestReqDataBuilder {
    private static long s_session_start_timestamp = System.currentTimeMillis();

    private static String _fixVariableValue(String value) {
        if (StringUtils.isBlank(value)) {
            return "-";
        }
        if (value != null && !"".equals(value)) {
            StringBuilder strNoBlank = new StringBuilder(value.length());
            char[] str = value.toCharArray();
            for (int i = 0; i < str.length; ++i) {
                if (str[i] == '\n' || str[i] == '\r' || str[i] == '\t' || str[i] == '|') continue;
                strNoBlank.append(str[i]);
            }
            return strNoBlank.toString();
        }
        return value;
    }

    public static String buildRequestData(long aTimestamp, String aPage, int aEventId, Object aArg1, Object aArg2, Object aArg3, Map<String, String> extData) {
        String appkey = SendService.getInstance().appKey;
        return RestReqDataBuilder.buildRequestData(appkey, aTimestamp, aPage, aEventId, aArg1, aArg2, aArg3, extData);
    }

    public static String buildRequestData(String userAppKey, long aTimestamp, String aPage, int aEventId, Object aArg1, Object aArg2, Object aArg3, Map<String, String> extData) {
        try {
            if (0 == aEventId) {
                return null;
            }
            String utdid = DeviceUtils.getUtdid(SendService.getInstance().context);
            if (utdid == null) {
                LogUtil.e("get utdid failure, so build report failure, now return");
                return null;
            }
            String[] networkStatus = DeviceUtils.getNetworkType(SendService.getInstance().context);
            String accessName = networkStatus[0];
            String accessSubTypeName = null;
            if (networkStatus.length > 1 && accessName != null && !"Wi-Fi".equals(accessName)) {
                accessSubTypeName = networkStatus[1];
            }
            long lTimestamp = aTimestamp > 0L ? aTimestamp : System.currentTimeMillis();
            String lRecordTimestamp = "" + lTimestamp;
            String lPage = RestReqDataBuilder._fixVariableValue(aPage);
            String lEventId = RestReqDataBuilder._fixVariableValue(String.valueOf(aEventId));
            String lArg1 = RestReqDataBuilder._fixVariableValue(StringUtils.convertObjectToString(aArg1));
            String lArg2 = RestReqDataBuilder._fixVariableValue(StringUtils.convertObjectToString(aArg2));
            String lArg3 = RestReqDataBuilder._fixVariableValue(StringUtils.convertObjectToString(aArg3));
            String lArgs = RestReqDataBuilder._fixVariableValue(StringUtils.convertMapToString(extData));
            String ndkReleaseVersion = "5.0.1";
            String imei = RestReqDataBuilder._fixVariableValue(DeviceUtils.getImei(SendService.getInstance().context));
            String imsi = RestReqDataBuilder._fixVariableValue(DeviceUtils.getImsi(SendService.getInstance().context));
            String brand = RestReqDataBuilder._fixVariableValue(Build.BRAND);
            String cpu = RestReqDataBuilder._fixVariableValue(DeviceUtils.getCpuName());
            String deviceId = RestReqDataBuilder._fixVariableValue(imei);
            String deviceModel = RestReqDataBuilder._fixVariableValue(Build.MODEL);
            String resolution = RestReqDataBuilder._fixVariableValue(DeviceUtils.getResolution(SendService.getInstance().context));
            String carrier = RestReqDataBuilder._fixVariableValue(DeviceUtils.getCarrier(SendService.getInstance().context));
            String access = RestReqDataBuilder._fixVariableValue(accessName);
            String accessSubType = RestReqDataBuilder._fixVariableValue(accessSubTypeName);
            String appKey = RestReqDataBuilder._fixVariableValue(userAppKey);
            String appVersion = RestReqDataBuilder._fixVariableValue(SendService.getInstance().appVersion);
            String channel = RestReqDataBuilder._fixVariableValue(SendService.getInstance().channel);
            String longLoginUserNick = RestReqDataBuilder._fixVariableValue(SendService.getInstance().userNick);
            String userNick = RestReqDataBuilder._fixVariableValue(SendService.getInstance().userNick);
            String phoneNumber = "-";
            String country = RestReqDataBuilder._fixVariableValue(DeviceUtils.getCountry());
            String language = RestReqDataBuilder._fixVariableValue(DeviceUtils.getLanguage());
            String appId = SendService.getInstance().appId;
            String os = "a";
            String osVersion = RestReqDataBuilder._fixVariableValue(Build.VERSION.RELEASE);
            String sdkType = "mini";
            String sdkReleaseVersion = "1.0";
            String reserve1 = "" + s_session_start_timestamp;
            String reserve2 = RestReqDataBuilder._fixVariableValue(utdid);
            String reserve3 = "-";
            String reserve4 = "-";
            String reserve5 = "-";
            String reserves = RestReqDataBuilder._fixVariableValue(SendService.getInstance().country);
            String reserve6 = "-";
            String lBundleVersion = "";
            if (!StringUtils.isBlank(lBundleVersion)) {
                reserve6 = lBundleVersion;
            }
            if (appId != null && appId.contains("aliyunos")) {
                os = "y";
            }
            HashMap<String, String> aLogMap = new HashMap<String, String>();
            aLogMap.put(RestFieldsScheme.IMEI.toString(), imei);
            aLogMap.put(RestFieldsScheme.IMSI.toString(), imsi);
            aLogMap.put(RestFieldsScheme.BRAND.toString(), brand);
            aLogMap.put(RestFieldsScheme.DEVICE_MODEL.toString(), deviceModel);
            aLogMap.put(RestFieldsScheme.RESOLUTION.toString(), resolution);
            aLogMap.put(RestFieldsScheme.CARRIER.toString(), carrier);
            aLogMap.put(RestFieldsScheme.ACCESS.toString(), access);
            aLogMap.put(RestFieldsScheme.ACCESS_SUBTYPE.toString(), accessSubType);
            aLogMap.put(RestFieldsScheme.CHANNEL.toString(), channel);
            aLogMap.put(RestFieldsScheme.APPKEY.toString(), appKey);
            aLogMap.put(RestFieldsScheme.APPVERSION.toString(), appVersion);
            aLogMap.put(RestFieldsScheme.LL_USERNICK.toString(), longLoginUserNick);
            aLogMap.put(RestFieldsScheme.USERNICK.toString(), userNick);
            aLogMap.put(RestFieldsScheme.LL_USERID.toString(), "-");
            aLogMap.put(RestFieldsScheme.USERID.toString(), "-");
            aLogMap.put(RestFieldsScheme.LANGUAGE.toString(), language);
            aLogMap.put(RestFieldsScheme.OS.toString(), os);
            aLogMap.put(RestFieldsScheme.OSVERSION.toString(), osVersion);
            aLogMap.put(RestFieldsScheme.SDKVERSION.toString(), sdkReleaseVersion);
            aLogMap.put(RestFieldsScheme.START_SESSION_TIMESTAMP.toString(), "" + s_session_start_timestamp);
            aLogMap.put(RestFieldsScheme.UTDID.toString(), reserve2);
            aLogMap.put(RestFieldsScheme.SDKTYPE.toString(), sdkType);
            aLogMap.put(RestFieldsScheme.RESERVE2.toString(), reserve2);
            aLogMap.put(RestFieldsScheme.RESERVE3.toString(), reserve3);
            aLogMap.put(RestFieldsScheme.RESERVE4.toString(), reserve4);
            aLogMap.put(RestFieldsScheme.RESERVE5.toString(), reserve5);
            aLogMap.put(RestFieldsScheme.RESERVES.toString(), reserves);
            aLogMap.put(RestFieldsScheme.RECORD_TIMESTAMP.toString(), lRecordTimestamp);
            aLogMap.put(RestFieldsScheme.PAGE.toString(), lPage);
            aLogMap.put(RestFieldsScheme.EVENTID.toString(), lEventId);
            aLogMap.put(RestFieldsScheme.ARG1.toString(), lArg1);
            aLogMap.put(RestFieldsScheme.ARG2.toString(), lArg2);
            aLogMap.put(RestFieldsScheme.ARG3.toString(), lArg3);
            aLogMap.put(RestFieldsScheme.ARGS.toString(), lArgs);
            return RestReqDataBuilder.assembleWithFullFields(aLogMap);
        }
        catch (Exception e) {
            LogUtil.e("UTRestAPI buildTracePostReqDataObj catch!", e);
            return "";
        }
    }

    public static String assembleWithFullFields(Map<String, String> aLogMap) {
        Map<String, String> lLogMapNew = aLogMap;
        StringBuffer lSb = new StringBuffer();
        for (RestFieldsScheme lEnumKey : RestFieldsScheme.values()) {
            if (lEnumKey == RestFieldsScheme.ARGS) break;
            String lV = null;
            if (lLogMapNew.containsKey(lEnumKey.toString())) {
                lV = StringUtils.convertObjectToString(lLogMapNew.get(lEnumKey.toString()));
                lLogMapNew.remove(lEnumKey.toString());
            }
            lSb.append(RestReqDataBuilder._fixVariableValue(lV)).append("||");
        }
        boolean lIsFirstArgFlag = true;
        if (lLogMapNew.containsKey(RestFieldsScheme.ARGS.toString())) {
            String lArgs = StringUtils.convertObjectToString(lLogMapNew.get(RestFieldsScheme.ARGS.toString()));
            lSb.append(RestReqDataBuilder._fixVariableValue(lArgs));
            lLogMapNew.remove(RestFieldsScheme.ARGS.toString());
            lIsFirstArgFlag = false;
        }
        for (String lKey : lLogMapNew.keySet()) {
            String lV = null;
            if (lLogMapNew.containsKey(lKey)) {
                lV = StringUtils.convertObjectToString(lLogMapNew.get(lKey));
            }
            if (lIsFirstArgFlag) {
                if ("StackTrace".equals(lKey)) {
                    lSb.append("StackTrace=====>").append(lV);
                } else {
                    lSb.append(RestReqDataBuilder._fixVariableValue(lKey)).append("=").append(lV);
                }
                lIsFirstArgFlag = false;
                continue;
            }
            if ("StackTrace".equals(lKey)) {
                lSb.append(",").append("StackTrace=====>").append(lV);
                continue;
            }
            lSb.append(",").append(RestReqDataBuilder._fixVariableValue(lKey)).append("=").append(lV);
        }
        String lLogResult = lSb.toString();
        if (!StringUtils.isEmpty(lLogResult) && lLogResult.endsWith("||")) {
            lLogResult = lLogResult + "-";
        }
        return lLogResult;
    }

    public static Map<String, Object> buildPostRequestMap(String lReqData) {
        if (StringUtils.isEmpty(lReqData)) {
            return null;
        }
        HashMap<String, String> newReqData = new HashMap<String, String>();
        newReqData.put("stm_x", lReqData);
        return RestReqDataBuilder.buildPostRequestMap(newReqData);
    }

    public static Map<String, Object> buildPostRequestMap(Map<String, String> lReqData) {
        if (null == lReqData || lReqData.size() <= 0) {
            return null;
        }
        try {
            HashMap<String, Object> lBReqData = new HashMap<String, Object>();
            for (String lRDKey : lReqData.keySet()) {
                String lRDValue = lReqData.get(lRDKey);
                if (StringUtils.isEmpty(lRDKey) || StringUtils.isEmpty(lRDValue)) continue;
                ByteArrayOutputStream lBaos = null;
                DeflaterOutputStream lOutputStream = null;
                try {
                    lBaos = new ByteArrayOutputStream();
                    lOutputStream = new GZIPOutputStream(lBaos);
                    lOutputStream.write(lRDValue.getBytes("UTF-8"));
                    lOutputStream.flush();
                    lOutputStream.close();
                    byte[] lGZIPResult = lBaos.toByteArray();
                    byte[] lBRC4ReqContent = RC4.rc4(lGZIPResult);
                    lBReqData.put(lRDKey, lBRC4ReqContent);
                }
                catch (IOException e) {
                    if (null != lOutputStream) {
                        lOutputStream.close();
                    }
                    if (null == lBaos) continue;
                    lBaos.close();
                }
            }
            return lBReqData;
        }
        catch (Exception e) {
            LogUtil.e("buildPostRequestMap", e);
            return null;
        }
    }

    public static RestReqDataBuildResult buildMonkeyPostReqDataObj(String URL2, Context aContext, long aTimestamp, String aPage, int aEventId, Object aArg1, Object aArg2, Object aArg3, Map<String, String> extData) {
        String appkey = SendService.getInstance().appKey;
        return RestReqDataBuilder.buildMonkeyPostReqDataObj(appkey, URL2, aContext, aTimestamp, aPage, aEventId, aArg1, aArg2, aArg3, extData);
    }

    public static RestReqDataBuildResult buildMonkeyPostReqDataObj(String userKey, String URL2, Context aContext, long aTimestamp, String aPage, int aEventId, Object aArg1, Object aArg2, Object aArg3, Map<String, String> extData) {
        try {
            if (0 == aEventId) {
                return null;
            }
            String utdid = DeviceUtils.getUtdid(SendService.getInstance().context);
            if (utdid == null) {
                LogUtil.e("get utdid failure, so build report failure, now return");
                return null;
            }
            String[] networkStatus = DeviceUtils.getNetworkType(SendService.getInstance().context);
            String accessName = networkStatus[0];
            String accessSubTypeName = null;
            if (networkStatus.length > 1 && accessName != null && !"Wi-Fi".equals(accessName)) {
                accessSubTypeName = networkStatus[1];
            }
            long lTimestamp = aTimestamp > 0L ? aTimestamp : System.currentTimeMillis();
            String lRecordTimestamp = "" + lTimestamp;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String lRecordDate = sdf.format(lTimestamp);
            String lPage = RestReqDataBuilder._fixVariableValue(aPage);
            String lEventId = RestReqDataBuilder._fixVariableValue(String.valueOf(aEventId));
            String lArg1 = RestReqDataBuilder._fixVariableValue(StringUtils.convertObjectToString(aArg1));
            String lArg2 = RestReqDataBuilder._fixVariableValue(StringUtils.convertObjectToString(aArg2));
            String lArg3 = RestReqDataBuilder._fixVariableValue(StringUtils.convertObjectToString(aArg3));
            String lArgs = RestReqDataBuilder._fixVariableValue(StringUtils.convertMapToString(extData));
            String ndkReleaseVersion = "5.0.1";
            String imei = RestReqDataBuilder._fixVariableValue(DeviceUtils.getImei(SendService.getInstance().context));
            String imsi = RestReqDataBuilder._fixVariableValue(DeviceUtils.getImsi(SendService.getInstance().context));
            String brand = RestReqDataBuilder._fixVariableValue(Build.BRAND);
            String cpu = RestReqDataBuilder._fixVariableValue(DeviceUtils.getCpuName());
            String deviceId = RestReqDataBuilder._fixVariableValue(imei);
            String deviceModel = RestReqDataBuilder._fixVariableValue(Build.MODEL);
            String resolution = RestReqDataBuilder._fixVariableValue(DeviceUtils.getResolution(SendService.getInstance().context));
            String carrier = RestReqDataBuilder._fixVariableValue(DeviceUtils.getCarrier(SendService.getInstance().context));
            String access = RestReqDataBuilder._fixVariableValue(accessName);
            String accessSubType = RestReqDataBuilder._fixVariableValue(accessSubTypeName);
            String appKey = RestReqDataBuilder._fixVariableValue(userKey);
            String appVersion = RestReqDataBuilder._fixVariableValue(SendService.getInstance().appVersion);
            String channel = RestReqDataBuilder._fixVariableValue(SendService.getInstance().channel);
            String longLoginUserNick = RestReqDataBuilder._fixVariableValue(SendService.getInstance().userNick);
            String userNick = RestReqDataBuilder._fixVariableValue(SendService.getInstance().userNick);
            String phoneNumber = "-";
            String country = RestReqDataBuilder._fixVariableValue(DeviceUtils.getCountry());
            String language = RestReqDataBuilder._fixVariableValue(DeviceUtils.getLanguage());
            String appId = SendService.getInstance().appId;
            String os = "Android";
            if (appId != null && appId.contains("aliyunos")) {
                os = "aliyunos";
            }
            String osVersion = RestReqDataBuilder._fixVariableValue(Build.VERSION.RELEASE);
            String sdkType = "mini";
            String sdkReleaseVersion = "1.0";
            String reserve1 = "" + s_session_start_timestamp;
            String reserve2 = RestReqDataBuilder._fixVariableValue(utdid);
            String reserve3 = "-";
            String reserve4 = "-";
            String reserve5 = "-";
            String reserve6 = "-";
            String lBundleVersion = "";
            if (!StringUtils.isBlank(lBundleVersion)) {
                reserve6 = lBundleVersion;
            }
            StringBuffer lSb = new StringBuffer();
            String split = "||";
            lSb.append(ndkReleaseVersion).append(split);
            lSb.append(imei).append(split);
            lSb.append(imsi).append(split);
            lSb.append(brand).append(split);
            lSb.append(cpu).append(split);
            lSb.append(deviceId).append(split);
            lSb.append(deviceModel).append(split);
            lSb.append(resolution).append(split);
            lSb.append(carrier).append(split);
            lSb.append(access).append(split);
            lSb.append(accessSubType).append(split);
            lSb.append(channel).append(split);
            lSb.append(appKey).append(split);
            lSb.append(appVersion).append(split);
            lSb.append(longLoginUserNick).append(split);
            lSb.append(userNick).append(split);
            lSb.append(phoneNumber).append(split);
            lSb.append(country).append(split);
            lSb.append(language).append(split);
            lSb.append(os).append(split);
            lSb.append(osVersion).append(split);
            lSb.append(sdkType).append(split);
            lSb.append(sdkReleaseVersion).append(split);
            lSb.append(reserve1).append(split);
            lSb.append(reserve2).append(split);
            lSb.append(reserve3).append(split);
            lSb.append(reserve4).append(split);
            lSb.append(reserve5).append(split);
            lSb.append("-").append(split);
            lSb.append(lRecordDate).append(split);
            lSb.append(lRecordTimestamp).append(split);
            lSb.append(lPage).append(split);
            lSb.append(lEventId).append(split);
            lSb.append(lArg1).append(split);
            lSb.append(lArg2).append(split);
            lSb.append(lArg3).append(split);
            lSb.append(lArgs);
            String lReqData = lSb.toString();
            HashMap<String, Object> lBReqData = new HashMap<String, Object>();
            byte[] byteReqData = lReqData.getBytes();
            lBReqData.put("stm_x", byteReqData);
            RestReqDataBuildResult lResult = new RestReqDataBuildResult();
            String lReqUrl = RestUrlWrapper.getSignedTransferUrl(URL2, null, lBReqData, aContext, appKey, channel, appVersion, os, "", reserve2);
            lResult.setReqUrl(lReqUrl);
            lResult.setPostReqData(lBReqData);
            return lResult;
        }
        catch (Exception e) {
            LogUtil.e("UTRestAPI buildTracePostReqDataObj catch!", e);
            return null;
        }
    }
}

