/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.motu.tbrest.rest;

import android.content.Context;
import com.alibaba.motu.tbrest.utils.LogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class RestSecuritySDKRequestAuthentication {
    private Context mContext;
    private String mAppkey = null;
    private Object s_securityGuardManagerObj = null;
    private Object s_secureSignatureCompObj = null;
    private Class s_securityGuardParamContextClz = null;
    private Field s_securityGuardParamContext_appKey = null;
    private Field s_securityGuardParamContext_paramMap = null;
    private Field s_securityGuardParamContext_requestType = null;
    private Method s_signRequestMethod = null;
    private int s_secureIndex = 1;
    private boolean mBInitSecurityCheck = false;

    public String getAppkey() {
        return this.mAppkey;
    }

    public RestSecuritySDKRequestAuthentication(Context context, String aAppkey) {
        this.mContext = context;
        this.mAppkey = aAppkey;
    }

    private synchronized void _initSecurityCheck() {
        block12: {
            if (this.mBInitSecurityCheck) {
                return;
            }
            Class<?> clz = null;
            try {
                clz = Class.forName("com.taobao.wireless.security.sdk.SecurityGuardManager");
                Method lgetInstanceMethod = clz.getMethod("getInstance", Context.class);
                this.s_securityGuardManagerObj = lgetInstanceMethod.invoke(null, this.mContext);
                Method lgetSecureSignatureComp = clz.getMethod("getSecureSignatureComp", new Class[0]);
                this.s_secureSignatureCompObj = lgetSecureSignatureComp.invoke(this.s_securityGuardManagerObj, new Object[0]);
            }
            catch (Throwable e) {
                LogUtil.i("initSecurityCheck failure, It's ok ");
            }
            try {
                if (clz == null) break block12;
                this.s_securityGuardParamContextClz = Class.forName("com.taobao.wireless.security.sdk.SecurityGuardParamContext");
                this.s_securityGuardParamContext_appKey = this.s_securityGuardParamContextClz.getDeclaredField("appKey");
                this.s_securityGuardParamContext_paramMap = this.s_securityGuardParamContextClz.getDeclaredField("paramMap");
                this.s_securityGuardParamContext_requestType = this.s_securityGuardParamContextClz.getDeclaredField("requestType");
                boolean lisThirdParty = false;
                Method lisOpenMethod = null;
                try {
                    lisOpenMethod = clz.getMethod("isOpen", new Class[0]);
                }
                catch (Throwable e) {
                    LogUtil.i("initSecurityCheck failure, It's ok");
                }
                if (lisOpenMethod != null) {
                    lisThirdParty = (Boolean)lisOpenMethod.invoke(this.s_securityGuardManagerObj, new Object[0]);
                } else {
                    Class<?> lBodyCompClz = null;
                    try {
                        lBodyCompClz = Class.forName("com.taobao.wireless.security.sdk.securitybody.ISecurityBodyComponent");
                    }
                    catch (Throwable e) {
                        LogUtil.i("initSecurityCheck failure, It's ok");
                    }
                    if (lBodyCompClz == null) {
                        lisThirdParty = true;
                    }
                }
                this.s_secureIndex = lisThirdParty ? 1 : 12;
                Class<?> lsignCompClz = Class.forName("com.taobao.wireless.security.sdk.securesignature.ISecureSignatureComponent");
                this.s_signRequestMethod = lsignCompClz.getMethod("signRequest", this.s_securityGuardParamContextClz);
            }
            catch (Throwable e) {
                LogUtil.i("initSecurityCheck failure, It's ok");
            }
        }
        this.mBInitSecurityCheck = true;
    }

    public String getSign(String toBeSignedStr) {
        if (!this.mBInitSecurityCheck) {
            this._initSecurityCheck();
        }
        if (this.mAppkey == null) {
            LogUtil.e("RestSecuritySDKRequestAuthentication:getSign There is no appkey,please check it!");
            return null;
        }
        if (toBeSignedStr == null) {
            return null;
        }
        String lSignedStr = null;
        if (this.s_securityGuardManagerObj != null && this.s_securityGuardParamContextClz != null && this.s_securityGuardParamContext_appKey != null && this.s_securityGuardParamContext_paramMap != null && this.s_securityGuardParamContext_requestType != null && this.s_signRequestMethod != null && this.s_secureSignatureCompObj != null) {
            try {
                Object lsecurityGuardParamContext = this.s_securityGuardParamContextClz.newInstance();
                this.s_securityGuardParamContext_appKey.set(lsecurityGuardParamContext, this.mAppkey);
                Map lParamMap = (Map)this.s_securityGuardParamContext_paramMap.get(lsecurityGuardParamContext);
                lParamMap.put("INPUT", toBeSignedStr);
                this.s_securityGuardParamContext_requestType.set(lsecurityGuardParamContext, this.s_secureIndex);
                lSignedStr = (String)this.s_signRequestMethod.invoke(this.s_secureSignatureCompObj, lsecurityGuardParamContext);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return lSignedStr;
    }
}

