/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.motu.tbrest.rest;

import android.content.Context;
import com.alibaba.motu.tbrest.rest.RestConstants;
import com.alibaba.motu.tbrest.rest.RestKeyArraySorter;
import com.alibaba.motu.tbrest.rest.RestSecuritySDKRequestAuthentication;
import com.alibaba.motu.tbrest.utils.LogUtil;
import com.alibaba.motu.tbrest.utils.MD5Utils;
import com.alibaba.motu.tbrest.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

public class RestUrlWrapper {
    public static final String FIELD_T = "t";
    public static final String FIELD_APPKEY = "appkey";
    public static final String FIELD_CHANNEL = "channel";
    public static final String FIELD_APPVERSION = "app_version";
    public static final String FIELD_PLATFORM = "platform";
    public static final String FIELD_SDK_VERSION = "sdk_version";
    public static final String FIELD_UTDID = "utdid";
    public static final String FIELD_V = "v";
    static boolean enableSecuritySDK = false;
    static Context mContext;

    public static void enableSecuritySDK() {
        enableSecuritySDK = true;
    }

    public static void setContext(Context context) {
        mContext = context;
    }

    public static String getSignedTransferUrl(String pUrl, Map<String, Object> pQueryMap, Map<String, Object> pDataMap, Context aContext, String aAppkey, String aChannel, String aAppVersion, String aPlatform, String aSdkVersion, String aUtdid) throws Exception {
        String lUrl;
        String lSignDataStr = "";
        if (null != pDataMap && pDataMap.size() > 0) {
            Set<String> keys = pDataMap.keySet();
            String[] lKeysArr = new String[keys.size()];
            keys.toArray(lKeysArr);
            for (String key : lKeysArr = RestKeyArraySorter.getInstance().sortResourcesList(lKeysArr, true)) {
                byte[] lValue = (byte[])pDataMap.get(key);
                lSignDataStr = lSignDataStr + key + MD5Utils.getMd5Hex(lValue);
            }
        }
        try {
            lUrl = RestUrlWrapper._wrapUrl(pUrl, null, null, lSignDataStr, aContext, aAppkey, aChannel, aAppVersion, aPlatform, aSdkVersion, aUtdid);
        }
        catch (Exception e) {
            lUrl = RestUrlWrapper._wrapUrl(RestConstants.getTransferUrl(), null, null, lSignDataStr, aContext, aAppkey, aChannel, aAppVersion, aPlatform, aSdkVersion, aUtdid);
        }
        return lUrl;
    }

    private static String _wrapUrl(String url, String pUrlQueryStr, String pSignQueryStr, String pSignDataStr, Context aContext, String aAppkey, String aChannel, String aAppVersion, String aPlatform, String aSdkVersion, String aUtdid) throws Exception {
        Context lContext = aContext;
        String lAppkey = aAppkey;
        String lChannel = aChannel;
        String lAppVersion = aAppVersion;
        String lPlatform = aPlatform;
        String lSdkVersion = "4.1.0";
        String lUtdid = aUtdid;
        String v = "3.0";
        String t = String.valueOf(System.currentTimeMillis());
        String lNewUrl = null;
        String lisSecureflag = "";
        String lSignValue = "";
        if (enableSecuritySDK && null != mContext) {
            try {
                String ltoBeSignedStr = lAppkey + lChannel + lAppVersion + lPlatform + lSdkVersion + lUtdid + t + v + lisSecureflag + (pSignQueryStr == null ? "" : pSignQueryStr) + (pSignDataStr == null ? "" : pSignDataStr);
                ltoBeSignedStr = MD5Utils.getMd5Hex(ltoBeSignedStr.getBytes());
                RestSecuritySDKRequestAuthentication lRequestAuthentication = new RestSecuritySDKRequestAuthentication(mContext, aAppkey);
                lSignValue = lRequestAuthentication.getSign(ltoBeSignedStr);
                if (StringUtils.isNotBlank(lSdkVersion)) {
                    lisSecureflag = "1";
                }
            }
            catch (Exception e) {
                LogUtil.w("security sdk signed", e);
            }
        }
        String lUrlQueryStr = "";
        if (!StringUtils.isEmpty(pUrlQueryStr)) {
            lUrlQueryStr = pUrlQueryStr + "&";
        }
        lNewUrl = String.format("%s?%sak=%s&av=%s&c=%s&v=%s&s=%s&d=%s&sv=%s&p=%s&t=%s&u=%s&is=%s", url, lUrlQueryStr, RestUrlWrapper._getEncoded(lAppkey), RestUrlWrapper._getEncoded(lAppVersion), RestUrlWrapper._getEncoded(lChannel), RestUrlWrapper._getEncoded(v), RestUrlWrapper._getEncoded(lSignValue), RestUrlWrapper._getEncoded(lUtdid), lSdkVersion, lPlatform, t, "", lisSecureflag);
        return lNewUrl;
    }

    private static String _getEncoded(String aValue) {
        if (null == aValue) {
            return "";
        }
        try {
            return URLEncoder.encode(aValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return aValue;
        }
    }
}

