/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.motu.tbrest.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Debug;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import com.alibaba.motu.tbrest.utils.LogUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class AppUtils {
    public static String getMyProcessNameByAppProcessInfo(Context context) {
        if (null != context) {
            int pid = Process.myPid();
            try {
                ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                for (ActivityManager.RunningAppProcessInfo appProcess : activityManager.getRunningAppProcesses()) {
                    if (appProcess.pid != pid) continue;
                    return appProcess.processName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getGMT8Time(long timestamp) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            return simpleDateFormat.format(new Date(timestamp));
        }
        catch (Exception e) {
            LogUtil.e("getGMT8Time", e);
            return "";
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LogUtil.e("close.", e);
            }
        }
    }

    public static String getMyProcessNameByCmdline() {
        try {
            return AppUtils.readLine("/proc/self/cmdline").trim();
        }
        catch (Exception e) {
            LogUtil.e("get my process name by cmd line failure .", e);
            return null;
        }
    }

    public static String getMyStatus() {
        return AppUtils.readFully(new File("/proc/self/status")).trim();
    }

    public static String getMeminfo() {
        return AppUtils.readFully(new File("/proc/meminfo")).trim();
    }

    public static String dumpThread(Thread thread) {
        StringBuilder sb = new StringBuilder();
        try {
            StackTraceElement[] stackTraces;
            sb.append(String.format("Thread Name: '%s'\n", thread.getName()));
            sb.append(String.format("\"%s\" prio=%d tid=%d %s\n", new Object[]{thread.getName(), thread.getPriority(), thread.getId(), thread.getState()}));
            for (StackTraceElement stackTraceElement : stackTraces = thread.getStackTrace()) {
                sb.append(String.format("\tat %s\n", stackTraceElement.toString()));
            }
        }
        catch (Exception e) {
            LogUtil.e("dumpThread", e);
        }
        return sb.toString();
    }

    public static String dumpMeminfo(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            Integer threshold = null;
            if (null != activityManager) {
                activityManager.getMemoryInfo(memoryInfo);
                threshold = (int)(memoryInfo.threshold >> 10);
            }
            return "JavaTotal:" + Runtime.getRuntime().totalMemory() + " JavaFree:" + Runtime.getRuntime().freeMemory() + " NativeHeap:" + Debug.getNativeHeapSize() + " NativeAllocated:" + Debug.getNativeHeapAllocatedSize() + " NativeFree:" + Debug.getNativeHeapFreeSize() + " threshold:" + (null != threshold ? threshold + " KB" : "not valid");
        }
        catch (Exception e) {
            LogUtil.e("dumpMeminfo", e);
            return "";
        }
    }

    private static long[] getSizes(String path) {
        long[] sizes = new long[]{-1L, -1L, -1L};
        try {
            StatFs statFs = new StatFs(path);
            long blockSize = 0L;
            long blockCount = 0L;
            long freeBlocks = 0L;
            long availableBlocks = 0L;
            if (Build.VERSION.SDK_INT < 18) {
                blockSize = statFs.getBlockSize();
                blockCount = statFs.getBlockCount();
                freeBlocks = statFs.getFreeBlocks();
                availableBlocks = statFs.getAvailableBlocks();
            } else {
                blockSize = statFs.getBlockSizeLong();
                blockCount = statFs.getBlockCountLong();
                freeBlocks = statFs.getFreeBlocksLong();
                availableBlocks = statFs.getAvailableBlocksLong();
            }
            sizes[0] = blockSize * blockCount;
            sizes[1] = blockSize * freeBlocks;
            sizes[2] = blockSize * availableBlocks;
        }
        catch (Exception e) {
            LogUtil.e("getSizes", e);
        }
        return sizes;
    }

    public static String dumpStorage(Context context) {
        StringBuilder stringBuffer = new StringBuilder();
        boolean hasSDCard = false;
        try {
            if ("mounted".equals(Environment.getExternalStorageState())) {
                hasSDCard = true;
            }
        }
        catch (Exception e) {
            LogUtil.w("hasSDCard", e);
        }
        boolean installSDCard = false;
        try {
            ApplicationInfo appInfo = context.getApplicationInfo();
            if ((appInfo.flags & 0x40000) != 0) {
                installSDCard = true;
            }
        }
        catch (Exception e) {
            LogUtil.w("installSDCard", e);
        }
        stringBuffer.append("hasSDCard: " + hasSDCard + "\n");
        stringBuffer.append("installSDCard: " + installSDCard + "\n");
        try {
            File downloadCacheDir;
            File dataDir;
            File rootDir = Environment.getRootDirectory();
            if (null != rootDir) {
                long[] sizes = AppUtils.getSizes(rootDir.getAbsolutePath());
                stringBuffer.append("RootDirectory: " + rootDir.getAbsolutePath() + " ");
                stringBuffer.append(String.format("TotalSize: %s FreeSize: %s AvailableSize: %s \n", sizes[0], sizes[1], sizes[2]));
            }
            if (null != (dataDir = Environment.getDataDirectory())) {
                long[] sizes = AppUtils.getSizes(dataDir.getAbsolutePath());
                stringBuffer.append("DataDirectory: " + dataDir.getAbsolutePath() + " ");
                stringBuffer.append(String.format("TotalSize: %s FreeSize: %s AvailableSize: %s \n", sizes[0], sizes[1], sizes[2]));
            }
            File externalStorageDir = Environment.getExternalStorageDirectory();
            if (null != dataDir) {
                stringBuffer.append("ExternalStorageDirectory: " + externalStorageDir.getAbsolutePath() + " ");
                long[] sizes = AppUtils.getSizes(externalStorageDir.getAbsolutePath());
                stringBuffer.append(String.format("TotalSize: %s FreeSize: %s AvailableSize: %s \n", sizes[0], sizes[1], sizes[2]));
            }
            if (null != (downloadCacheDir = Environment.getDownloadCacheDirectory())) {
                stringBuffer.append("DownloadCacheDirectory: " + downloadCacheDir.getAbsolutePath() + " ");
                long[] sizes = AppUtils.getSizes(downloadCacheDir.getAbsolutePath());
                stringBuffer.append(String.format("TotalSize: %s FreeSize: %s AvailableSize: %s \n", sizes[0], sizes[1], sizes[2]));
            }
        }
        catch (Exception e) {
            LogUtil.e("getSizes", e);
        }
        return stringBuffer.toString();
    }

    public static Boolean isBackgroundRunning(Context context) {
        try {
            String oom_adjline = AppUtils.readLine("/proc/self/oom_adj").trim();
            int oom_adj = Integer.parseInt(oom_adjline);
            if (0 == oom_adj) {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean writeFile(File file, String str) {
        return AppUtils.writeFile(file, str, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeFile(File file, String str, boolean append) {
        boolean bl;
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, append);
            writer.write(str);
            writer.flush();
            bl = true;
        }
        catch (IOException e) {
            try {
                LogUtil.e("writeFile", e);
            }
            catch (Throwable throwable) {
                AppUtils.closeQuietly(writer);
                throw throwable;
            }
            AppUtils.closeQuietly(writer);
            return false;
        }
        AppUtils.closeQuietly(writer);
        return bl;
    }

    public static String readLine(String filePath) {
        return AppUtils.readLine(new File(filePath));
    }

    public static String readLine(File file) {
        List<String> lines = AppUtils.readLines(file, 1);
        return !lines.isEmpty() ? lines.get(0) : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file, int n) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int count = 0;
            while (null != (line = reader.readLine())) {
                lines.add(line);
                if (n <= 0 || ++count < n) continue;
            }
            AppUtils.closeQuietly(reader);
        }
        catch (IOException e) {
            LogUtil.e("readLine", e);
        }
        finally {
            AppUtils.closeQuietly(reader);
        }
        return lines;
    }

    public static String readLineAndDel(File file) {
        try {
            String line = AppUtils.readLine(file);
            file.delete();
            return line;
        }
        catch (Exception e) {
            LogUtil.e("readLineAndDel", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readLine(File file, ReaderListener listener) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while (null != (line = reader.readLine())) {
                if (!listener.onReadLine(line)) continue;
                AppUtils.closeQuietly(reader);
                return;
            }
            AppUtils.closeQuietly(reader);
        }
        catch (IOException e) {
            LogUtil.e("readLine", e);
        }
        finally {
            AppUtils.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(File file) {
        StringBuilder builder;
        block6: {
            builder = new StringBuilder();
            FileInputStream in = null;
            InputStreamReader input = null;
            try {
                in = new FileInputStream(file);
                input = new InputStreamReader(in);
                int DEFAULT_BUFFER_SIZE = 4096;
                char[] buffer = new char[DEFAULT_BUFFER_SIZE];
                int n = 0;
                while (-1 != (n = input.read(buffer))) {
                    builder.append(buffer, 0, n);
                }
                AppUtils.closeQuietly(input);
            }
            catch (Exception e) {
                LogUtil.e("readFully.", e);
                break block6;
            }
            finally {
                AppUtils.closeQuietly(input);
                AppUtils.closeQuietly(in);
            }
            AppUtils.closeQuietly(in);
        }
        return builder.toString();
    }

    public static interface ReaderListener {
        public boolean onReadLine(String var1);
    }
}

