/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.motu.tbrest.utils;

public class ByteUtils {
    public static int bytesToInt(byte[] buf, int offset, int len) {
        if (null == buf || offset < 0 || len < 0 || buf.length < offset + len) {
            return 0;
        }
        byte[] tempbuf = new byte[len];
        for (int i = 0; i < len; ++i) {
            tempbuf[i] = buf[offset];
            ++offset;
        }
        return ByteUtils.bytesToInt(tempbuf);
    }

    public static int bytesToInt(byte[] buf) {
        if (null == buf || buf.length > 4) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < buf.length; ++i) {
            ret |= (buf[i] & 0xFF) << (buf.length - i - 1) * 8;
        }
        return ret;
    }

    public static String bytes2UTF8String(byte[] buf) {
        String dst = "";
        try {
            dst = new String(buf, "UTF-8");
        }
        catch (Exception e) {
            dst = "";
        }
        return dst;
    }

    public static String bytes2UTF8string(byte[] buf, int offset, int len) {
        if (null == buf || offset < 0 || len < 0 || buf.length < offset + len) {
            return "";
        }
        byte[] tempbuf = new byte[len];
        for (int i = 0; i < len; ++i) {
            tempbuf[i] = buf[offset];
            ++offset;
        }
        return ByteUtils.bytes2UTF8String(tempbuf);
    }

    public static byte[] intToBytes(int i, int n) {
        if (n > 4 || n < 1) {
            return null;
        }
        byte[] buf = new byte[n];
        for (int j = 0; j < n; ++j) {
            buf[j] = (byte)(i >> 8 * (n - j - 1) & 0xFF);
        }
        return buf;
    }

    public static byte[] intToBytes1(int i) {
        byte[] result = new byte[]{(byte)(i & 0xFF)};
        return result;
    }

    public static byte[] intToBytes2(int i) {
        byte[] result = new byte[]{(byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static byte[] intToBytes3(int i) {
        byte[] result = new byte[]{(byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static byte[] intToBytes4(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static byte[] subBytes(byte[] buf, int offset, int len) {
        if (null == buf || offset < 0 || len < 0 || buf.length < offset + len) {
            return null;
        }
        byte[] bs = new byte[len];
        for (int i = offset; i < offset + len; ++i) {
            bs[i - offset] = buf[i];
        }
        return bs;
    }
}

