/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.motu.tbrest.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.alibaba.motu.tbrest.utils.Base64;
import com.alibaba.motu.tbrest.utils.LogUtil;
import com.alibaba.motu.tbrest.utils.StringUtils;
import com.ta.utdid2.device.UTDevice;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;

public class DeviceUtils {
    private static String cpuName = null;
    private static String carrier = null;
    public static final String NETWORK_CLASS_WIFI = "Wi-Fi";
    private static final String NETWORK_CLASS_2_G = "2G";
    private static final String NETWORK_CLASS_3_G = "3G";
    private static final String NETWORK_CLASS_4_G = "4G";
    private static final String NETWORK_CLASS_UNKNOWN = "Unknown";
    private static String[] arrayOfString = new String[]{"Unknown", "Unknown"};
    private static String imsi = null;
    private static String imei = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCpuName() {
        if (cpuName != null) {
            return cpuName;
        }
        String str1 = "/proc/cpuinfo";
        String str2 = "";
        FileReader fr = null;
        BufferedReader localBufferedReader = null;
        try {
            fr = new FileReader(str1);
            localBufferedReader = new BufferedReader(fr);
            while ((str2 = localBufferedReader.readLine()) != null) {
                if (!str2.contains("Hardware")) continue;
                String string = cpuName = str2.split(":")[1];
                return string;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
                if (localBufferedReader != null) {
                    localBufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static String getCarrier(Context context) {
        try {
            if (carrier != null) {
                return carrier;
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            carrier = telephonyManager.getNetworkOperatorName();
            return carrier;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public static String[] getNetworkType(Context context) {
        if (context == null) {
            return arrayOfString;
        }
        try {
            PackageManager pManager = context.getPackageManager();
            if (pManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName()) != 0) {
                return arrayOfString;
            }
            ConnectivityManager cManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (cManager == null) {
                return arrayOfString;
            }
            NetworkInfo nInfo = cManager.getActiveNetworkInfo();
            if (nInfo == null) {
                return arrayOfString;
            }
            if (nInfo.isConnected()) {
                if (nInfo.getType() == 1) {
                    DeviceUtils.arrayOfString[0] = NETWORK_CLASS_WIFI;
                    return arrayOfString;
                }
                if (nInfo.getType() == 0) {
                    DeviceUtils.arrayOfString[0] = DeviceUtils.getNetworkClass(nInfo.getSubtype());
                    DeviceUtils.arrayOfString[1] = nInfo.getSubtypeName();
                    return arrayOfString;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return arrayOfString;
    }

    private static String getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return NETWORK_CLASS_2_G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return NETWORK_CLASS_3_G;
            }
            case 13: {
                return NETWORK_CLASS_4_G;
            }
        }
        return NETWORK_CLASS_UNKNOWN;
    }

    public static String getLanguage() {
        try {
            return Locale.getDefault().getLanguage();
        }
        catch (Exception e) {
            LogUtil.e("get country error ", e);
            return null;
        }
    }

    public static String getCountry() {
        try {
            return Locale.getDefault().getCountry();
        }
        catch (Exception e) {
            LogUtil.e("get country error ", e);
            return null;
        }
    }

    public static String getResolution(Context context) {
        String resolution = NETWORK_CLASS_UNKNOWN;
        try {
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            int width = dm.widthPixels;
            int height = dm.heightPixels;
            if (width > height) {
                width ^= height;
                height ^= width;
                width ^= height;
            }
            resolution = height + "*" + width;
        }
        catch (Exception e) {
            LogUtil.e("DeviceUtils getResolution: error", e);
        }
        return resolution;
    }

    public static String getUtdid(Context context) {
        try {
            return UTDevice.getUtdid((Context)context);
        }
        catch (Exception e) {
            LogUtil.e("get utdid error ", e);
            return null;
        }
    }

    public static String getImsi(Context context) {
        if (imsi != null) {
            return imsi;
        }
        if (context != null) {
            try {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                if (tm != null) {
                    imsi = tm.getSubscriberId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty(imsi)) {
            imsi = DeviceUtils.getUniqueID();
        }
        return imsi;
    }

    public static String getImei(Context context) {
        if (imei != null) {
            return imei;
        }
        imei = DeviceUtils.getUniqueID();
        return imei;
    }

    public static byte[] IntGetBytes(int i) {
        byte[] bInt = new byte[4];
        int value = i;
        bInt[3] = (byte)(value % 256);
        bInt[2] = (byte)((value >>= 8) % 256);
        bInt[1] = (byte)((value >>= 8) % 256);
        bInt[0] = (byte)((value >>= 8) % 256);
        return bInt;
    }

    public static final String getUniqueID() {
        try {
            int t1 = (int)(System.currentTimeMillis() / 1000L);
            int t2 = (int)System.nanoTime();
            int t3 = new Random().nextInt();
            int t4 = new Random().nextInt();
            byte[] b1 = DeviceUtils.IntGetBytes(t1);
            byte[] b2 = DeviceUtils.IntGetBytes(t2);
            byte[] b3 = DeviceUtils.IntGetBytes(t3);
            byte[] b4 = DeviceUtils.IntGetBytes(t4);
            byte[] bUniqueID = new byte[16];
            System.arraycopy(b1, 0, bUniqueID, 0, 4);
            System.arraycopy(b2, 0, bUniqueID, 4, 4);
            System.arraycopy(b3, 0, bUniqueID, 8, 4);
            System.arraycopy(b4, 0, bUniqueID, 12, 4);
            return Base64.encodeBase64String(bUniqueID);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

