/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.httpdns.net;

import com.alibaba.sdk.android.httpdns.log.HttpDnsLog;
import com.alibaba.sdk.android.httpdns.net.a;
import com.alibaba.sdk.android.httpdns.net.b;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Inet64Util {
    static final String TAG = "Inet64Util";
    static final String IPV4ONLY_HOST = "ipv4only.arpa";
    static final byte[][] IPV4ONLY_IP = new byte[][]{{-64, 0, 0, -86}, {-64, 0, 0, -85}};
    public static final int IP_STACK_UNKNOWN = 0;
    public static final int IPV4_ONLY = 1;
    public static final int IPV6_ONLY = 2;
    public static final int IP_DUAL_STACK = 3;
    static volatile String networkId = null;
    static b defaultNatPrefix = null;
    static ConcurrentHashMap<String, b> nat64PrefixMap = new ConcurrentHashMap();
    static ConcurrentHashMap<String, Integer> ipStackMap = new ConcurrentHashMap();
    private static a helper;
    private static ScheduledExecutorService threadPool;

    public static void init(a a2) {
        if (helper != null) {
            return;
        }
        helper = a2;
        threadPool = Executors.newScheduledThreadPool(2);
        try {
            defaultNatPrefix = new b((Inet6Address)InetAddress.getAllByName("64:ff9b::")[0], 96);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        networkId = a2.i();
        Inet64Util.startIpStackDetect();
    }

    public static boolean isIPv6OnlyNetwork() {
        Integer n2 = ipStackMap.get(networkId);
        return n2 != null && n2 == 2;
    }

    public static boolean isIPv4OnlyNetwork() {
        Integer n2 = ipStackMap.get(networkId);
        return n2 != null && n2 == 1;
    }

    public static int getStackType() {
        Integer n2 = ipStackMap.get(networkId);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public static b getNat64Prefix() {
        b b2 = nat64PrefixMap.get(networkId);
        if (b2 == null) {
            b2 = defaultNatPrefix;
        }
        return b2;
    }

    public static String convertToIPv6(Inet4Address inet4Address) {
        if (inet4Address == null) {
            throw new InvalidParameterException("address in null");
        }
        b b2 = Inet64Util.getNat64Prefix();
        if (b2 == null) {
            throw new Exception("cannot get nat64 prefix");
        }
        byte[] byArray = inet4Address.getAddress();
        byte[] byArray2 = b2.a.getAddress();
        int n2 = b2.h / 8;
        int n3 = 0;
        int n4 = 0;
        while (n3 + n2 <= 15 && n4 < 4) {
            if (n2 + n3 != 8) {
                int n5 = n2 + n3;
                byArray2[n5] = (byte)(byArray2[n5] | byArray[n4++]);
            }
            ++n3;
        }
        return InetAddress.getByAddress(byArray2).getHostAddress();
    }

    public static String convertToIPv6(String string) {
        try {
            Inet4Address inet4Address = (Inet4Address)Inet4Address.getByName(string);
            return Inet64Util.convertToIPv6(inet4Address);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int getIpStackByInterfaces() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface networkInterface : Collections.list(enumeration)) {
            List<InterfaceAddress> list = networkInterface.getInterfaceAddresses();
            if (list.isEmpty()) continue;
            String object2 = networkInterface.getDisplayName();
            HttpDnsLog.d("Inet64Util find NetworkInterface:" + object2);
            int n2 = 0;
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                InetAddress inetAddress;
                InetAddress inetAddress2 = interfaceAddress.getAddress();
                if (inetAddress2 instanceof Inet6Address) {
                    inetAddress = (Inet6Address)inetAddress2;
                    if (Inet64Util.filterAddress(inetAddress)) continue;
                    HttpDnsLog.d("Inet64Util Found IPv6 address:" + inetAddress.toString());
                    n2 |= 2;
                    continue;
                }
                if (!(inetAddress2 instanceof Inet4Address) || Inet64Util.filterAddress(inetAddress = (Inet4Address)inetAddress2) || ((Inet4Address)inetAddress).getHostAddress().startsWith("192.168.43.")) continue;
                HttpDnsLog.d("Inet64Util Found IPv4 address:" + inetAddress.toString());
                n2 |= 1;
            }
            if (n2 == 0) continue;
            treeMap.put(object2.toLowerCase(), n2);
        }
        if (treeMap.isEmpty()) {
            return 0;
        }
        if (treeMap.size() == 1) {
            return (Integer)treeMap.firstEntry().getValue();
        }
        Object object = null;
        if (helper.c()) {
            object = "wlan";
        } else if (helper.d()) {
            object = "rmnet";
        }
        int n3 = 0;
        if (object != null) {
            for (Map.Entry entry : treeMap.entrySet()) {
                if (!((String)entry.getKey()).startsWith((String)object)) continue;
                n3 = (Integer)entry.getValue();
                break;
            }
        }
        if (n3 == 2 && treeMap.containsKey("v4-wlan0")) {
            n3 |= ((Integer)treeMap.remove("v4-wlan0")).intValue();
        }
        return n3;
    }

    public static void startIpStackDetect() {
        networkId = helper.i();
        if (ipStackMap.putIfAbsent(networkId, 0) != null) {
            return;
        }
        int n2 = Inet64Util.detectIpStack();
        ipStackMap.put(networkId, n2);
        final int n3 = n2;
        final String string = networkId;
        if (n2 == 2 || n2 == 3) {
            threadPool.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        b b2;
                        String string2 = helper.i();
                        if (!string.equals(string2)) {
                            return;
                        }
                        HttpDnsLog.d("Inet64Util startIpStackDetect double check");
                        int n2 = Inet64Util.detectIpStack();
                        if (n3 != n2) {
                            ipStackMap.put(string, n2);
                        }
                        if ((n2 == 2 || n2 == 3) && (b2 = Inet64Util.detectNat64Prefix()) != null) {
                            nat64PrefixMap.put(string, b2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 1500L, TimeUnit.MILLISECONDS);
        }
    }

    private static int detectIpStack() {
        int n2 = 0;
        try {
            n2 = Inet64Util.getIpStackByInterfaces();
        }
        catch (Throwable throwable) {
            HttpDnsLog.e("Inet64Util[detectIpStack]error.");
        }
        HttpDnsLog.d("Inet64UtilstartIpStackDetect ip stack " + n2);
        return n2;
    }

    private static boolean filterAddress(InetAddress inetAddress) {
        return inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isAnyLocalAddress();
    }

    private static b detectNat64Prefix() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(IPV4ONLY_HOST);
        }
        catch (Exception exception) {
            HttpDnsLog.e("Inet64Util detectNat64Prefix " + exception.getMessage(), exception);
        }
        if (inetAddress instanceof Inet6Address) {
            int n2;
            HttpDnsLog.d("Inet64Util Resolved AAAA: " + inetAddress.toString());
            byte[] byArray = inetAddress.getAddress();
            if (byArray.length != 16) {
                return null;
            }
            boolean bl = false;
            for (n2 = 12; n2 >= 0; --n2) {
                if ((byArray[n2] & IPV4ONLY_IP[0][0]) == 0 || byArray[n2 + 1] != 0 || byArray[n2 + 2] != 0 || byArray[n2 + 3] != IPV4ONLY_IP[0][3] && byArray[n2 + 3] != IPV4ONLY_IP[1][3]) continue;
                bl = true;
                break;
            }
            if (bl) {
                byArray[n2 + 3] = 0;
                byArray[n2 + 2] = 0;
                byArray[n2 + 1] = 0;
                byArray[n2] = 0;
                Inet6Address inet6Address = Inet6Address.getByAddress(IPV4ONLY_HOST, byArray, 0);
                b b2 = new b(inet6Address, n2 * 8);
                return b2;
            }
        } else if (inetAddress instanceof Inet4Address) {
            HttpDnsLog.d("Inet64UtilResolved A: " + inetAddress.toString());
        }
        return null;
    }
}

