/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man;

import android.app.Application;
import android.content.Context;
import com.alibaba.sdk.android.man.MANPageHitHelper;
import com.alibaba.sdk.android.man.MANTracker;
import com.alibaba.sdk.android.man.crashreporter.MotuCrashReporter;
import com.alibaba.sdk.android.man.customperf.MANCustomPerformance;
import com.alibaba.sdk.android.man.util.EventCommitTool;
import com.alibaba.sdk.android.man.util.MANLog;
import com.alibaba.sdk.android.man.util.ToolKit;
import com.alibaba.sdk.android.man.util.UTWrapper;
import com.alibaba.sdk.android.utils.AMSConfigUtils;
import com.alibaba.sdk.android.utils.AlicloudTrackerManager;
import com.alibaba.sdk.android.utils.crashdefend.SDKMessageCallback;
import com.ut.mini.IUTApplication;
import com.ut.mini.UTAnalytics;
import com.ut.mini.UTPageHitHelper;
import com.ut.mini.core.sign.IUTRequestAuthentication;
import com.ut.mini.core.sign.UTBaseRequestAuthentication;
import com.ut.mini.crashhandler.IUTCrashCaughtListner;

public class MANAnalytics {
    private String appVersion = "";
    private String channel = "";
    private Boolean turnOnDebug = false;
    public final String TAG = "MAN_MANAnalytics";
    private static final String PRODUCT = "man";
    private static final int crashLimitCount = 10;
    private static final int initTimeSecond = 5;
    private volatile Boolean isEnabled = true;

    private MANAnalytics() {
    }

    protected static MANAnalytics getInstance() {
        return Singleton.instance;
    }

    public MANTracker getDefaultTracker() {
        return MANTracker.getInstance();
    }

    public void sendCustomPerformance(MANCustomPerformance mANCustomPerformance) {
        if (!this.isEnabled.booleanValue()) {
            MANLog.Loge("MAN_MANAnalytics", "MAN init failed,can not work for now!");
            return;
        }
        if (mANCustomPerformance != null) {
            if (mANCustomPerformance.getDuration() == -1L || ToolKit.isNullOrEmpty(mANCustomPerformance.getEventLabel())) {
                return;
            }
            EventCommitTool.commitCustomPerformanceEvent(mANCustomPerformance);
        }
    }

    public boolean init(Application application, Context context) {
        if (context == null || application == null) {
            MANLog.Loge("MAN_MANAnalytics", "MAN init failed, app context can't be null.");
            return false;
        }
        String string = AMSConfigUtils.getAppKey((Context)context);
        String string2 = AMSConfigUtils.getAppSecret((Context)context);
        if (ToolKit.isNullOrEmpty(string)) {
            string = ToolKit.getMetaDataAppKey(context);
        }
        if (ToolKit.isNullOrEmpty(string2)) {
            string2 = ToolKit.getMetaDataAppSecret(context);
        }
        if (!ToolKit.isNullOrEmpty(string) && !ToolKit.isNullOrEmpty(string2)) {
            this.init(application, context, string, string2);
            return true;
        }
        MANLog.Loge("MAN_MANAnalytics", "MAN init failed, invalid appKey/appSecret.");
        return false;
    }

    public void init(Application application, Context context, String string, String string2) {
        if (context == null || application == null) {
            MANLog.Loge("MAN_MANAnalytics", "MAN init failed, app context can't be null.");
            return;
        }
        AlicloudTrackerManager.getInstance((Application)application).registerCrashDefend(PRODUCT, "1.2.4", 10, 5, new SDKMessageCallback(){

            public void crashDefendMessage(int n, int n2) {
                if (n > n2) {
                    MANAnalytics.this.isEnabled = true;
                    MANLog.Logd("MAN_MANAnalytics", "MAN init success.");
                } else {
                    MANAnalytics.this.isEnabled = false;
                    MANLog.Loge("MAN_MANAnalytics", "MAN init failed,cause crashCount > limitCount!");
                }
                MANTracker.getInstance().setEnableStatus(MANAnalytics.this.isEnabled);
                MANPageHitHelper.getInstance().setEnableStatus(MANAnalytics.this.isEnabled);
            }
        });
        if (this.isEnabled.booleanValue()) {
            MANLog.Logd("MAN_MANAnalytics", "isEnabled is true, so execute init function!");
            this.innerInit(application, context, string, string2);
        }
    }

    private void innerInit(Application application, Context context, final String string, final String string2) {
        if (this.appVersion.isEmpty()) {
            this.appVersion = ToolKit.getMetaDataAppVersion(context);
        }
        if (this.channel.isEmpty()) {
            this.channel = ToolKit.getMetaDataChannel(context);
        }
        UTWrapper.utInit(string, string2, application);
        UTAnalytics.getInstance().setAppApplicationInstance(application, new IUTApplication(){

            public String getUTAppVersion() {
                return MANAnalytics.this.appVersion;
            }

            public String getUTChannel() {
                return MANAnalytics.this.channel;
            }

            public IUTRequestAuthentication getUTRequestAuthInstance() {
                return new UTBaseRequestAuthentication(string, string2, false);
            }

            public boolean isUTLogEnable() {
                return MANAnalytics.this.turnOnDebug;
            }

            public IUTCrashCaughtListner getUTCrashCraughtListener() {
                return null;
            }

            public boolean isAliyunOsSystem() {
                return false;
            }

            public boolean isUTCrashHandlerDisable() {
                return true;
            }
        });
        MANTracker mANTracker = MANTracker.getInstance();
        mANTracker.appKey = string;
        this.initMANInternal(context, string, this.appVersion);
        UTWrapper.commitDAUEvent(context);
    }

    public void turnOffCrashReporter() {
        if (MotuCrashReporter.getInstance().turnoffCrashReporter()) {
            MANLog.Logi("CrashReporter", "Turn off success.");
        }
    }

    public void initMANInternal(Context context, String string, String string2) {
        this.setMetaDataChannel(context);
        if (MotuCrashReporter.getInstance().enable(context, string, string2, null, null, null)) {
            MANLog.Logi("CrashReporter", "Turn on success.");
        } else {
            MANLog.Loge("CrashReporter", "Turn on fail.");
        }
    }

    public void setAppVersion(String string) {
        this.appVersion = string;
        MotuCrashReporter.getInstance().setAppVersion(string);
        UTAnalytics.getInstance().setAppVersion(string);
    }

    public void setChannel(String string) {
        this.channel = string;
    }

    public void turnOnDebug() {
        this.turnOnDebug = true;
        MANLog.enableLog();
    }

    public void updateUserAccount(String string, String string2) {
        if (!this.isEnabled.booleanValue()) {
            MANLog.Loge("MAN_MANAnalytics", "MAN init failed,can not work for now!");
            return;
        }
        UTAnalytics.getInstance().updateUserAccount(string, string2);
        UTWrapper.commitUserEvent("2");
    }

    public void userRegister(String string) {
        if (!this.isEnabled.booleanValue()) {
            MANLog.Loge("MAN_MANAnalytics", "MAN init failed,can not work for now!");
            return;
        }
        UTAnalytics.getInstance().userRegister(string);
        UTWrapper.commitUserEvent("1");
    }

    public void turnOffAutoPageTrack() {
        if (!this.isEnabled.booleanValue()) {
            MANLog.Loge("MAN_MANAnalytics", "MAN init failed,can not work for now!");
            return;
        }
        UTPageHitHelper.getInstance().turnOffAutoPageTrack();
    }

    private void setMetaDataChannel(Context context) {
        String string = ToolKit.getMetaDataChannel(context);
        if (!string.equals("")) {
            this.channel = string;
        }
    }

    private static class Singleton {
        static MANAnalytics instance = new MANAnalytics();

        private Singleton() {
        }
    }
}

