/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man;

import android.util.Log;
import com.alibaba.sdk.android.man.customperf.MANCustomPerformance;
import com.alibaba.sdk.android.man.network.NetworkEvent;
import com.alibaba.sdk.android.man.util.EventCommitTool;
import com.alibaba.sdk.android.man.util.MANLog;
import com.alibaba.sdk.android.man.util.UTWrapper;
import com.ut.mini.UTAnalytics;
import com.ut.mini.UTTracker;
import java.util.Map;

public class MANTracker {
    public String appKey;
    private static final String TAG = MANTracker.class.getSimpleName();
    private volatile boolean isEnabled = true;

    private MANTracker() {
    }

    public static MANTracker getInstance() {
        return Singleton.instance;
    }

    public void send(Map<String, String> map) {
        if (!this.isEnabled) {
            MANLog.Loge(TAG, "MAN init failed,can not work for now!");
            return;
        }
        UTTracker uTTracker = this.getTrackerFromUt();
        if (null == uTTracker) {
            return;
        }
        uTTracker.send(map);
        UTWrapper.commitCustomEvent();
    }

    public void send(MANCustomPerformance mANCustomPerformance) {
        if (!this.isEnabled) {
            MANLog.Loge(TAG, "MAN init failed,can not work for now!");
            return;
        }
        EventCommitTool.commitCustomPerformanceEvent(mANCustomPerformance);
        UTWrapper.commitPerfEvent("3");
    }

    public void send(NetworkEvent networkEvent) {
        if (!this.isEnabled) {
            MANLog.Loge(TAG, "MAN init failed,can not work for now!");
            return;
        }
        if (networkEvent != null) {
            networkEvent.reportNetworkInfo();
            String string = "1";
            if (networkEvent.isAdvancedStat()) {
                string = "2";
            }
            UTWrapper.commitPerfEvent(string);
        }
    }

    private UTTracker getTrackerFromUt() {
        UTTracker uTTracker = UTAnalytics.getInstance().getTrackerByAppkey(this.appKey);
        if (null == uTTracker) {
            Log.e((String)"MAN", (String)"\u8bf7\u5148\u521d\u59cb\u5316MAN");
        }
        return uTTracker;
    }

    public void setEnableStatus(boolean bl) {
        this.isEnabled = bl;
    }

    private static class Singleton {
        static MANTracker instance = new MANTracker();

        private Singleton() {
        }
    }
}

