/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man.crashreporter.handler.nativeCrashHandler;

import android.content.Context;
import com.alibaba.sdk.android.man.crashreporter.MotuCrashReporter;
import com.alibaba.sdk.android.man.crashreporter.c;
import com.alibaba.sdk.android.man.crashreporter.handler.a;
import com.alibaba.sdk.android.man.crashreporter.handler.nativeCrashHandler.NativeExceptionHandler;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class NativeCrashHandler
implements NativeExceptionHandler {
    private AtomicBoolean crashing;
    private static boolean LOAD_SUCCESS = false;
    private static NativeCrashHandler nativeCrashHandler;
    private final String MOTU_PATH = "motu";
    private final String TOMBSTONE_PATH = "tombstone";
    private final String motuPath;
    private a crashReportManager = null;

    public static native String regist(String var0, boolean var1, int var2, long var3, String var5);

    public static native String resetSigHandler();

    public static native String unregist();

    public NativeExceptionHandler getNativeExceptionHandler() {
        return nativeCrashHandler;
    }

    public static synchronized NativeCrashHandler getInstance() {
        return nativeCrashHandler;
    }

    public static synchronized NativeCrashHandler init(Context context) {
        if (nativeCrashHandler == null) {
            nativeCrashHandler = new NativeCrashHandler(context);
        }
        return nativeCrashHandler;
    }

    private NativeCrashHandler(Context context) {
        File file = context.getDir("tombstone", 0);
        this.motuPath = String.format("%s/%s", file.getAbsolutePath(), "motu");
        File file2 = new File(this.motuPath);
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    public boolean removeNativeCrashHandler() {
        if (NativeCrashHandler.resetSigHandler() != null) {
            com.alibaba.sdk.android.man.crashreporter.b.a.e("Native crash handler is removed success");
            return true;
        }
        com.alibaba.sdk.android.man.crashreporter.b.a.e("Native crash handler is removed failed");
        return false;
    }

    public boolean regist(AtomicBoolean atomicBoolean, a a2, boolean bl, c c2) {
        if (LOAD_SUCCESS) {
            this.crashing = atomicBoolean;
            this.crashReportManager = a2;
            String string = c2.appVersion;
            if (string == null) {
                string = "";
            }
            try {
                return NativeCrashHandler.regist(this.motuPath, false, 1, c2.startupTime, string) != null;
            }
            catch (Exception exception) {
                com.alibaba.sdk.android.man.crashreporter.b.a.d("regist native crash err", exception);
                return false;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                com.alibaba.sdk.android.man.crashreporter.b.a.d("regist native crash err,UnsatisfiedLinkError:", unsatisfiedLinkError);
                return false;
            }
        }
        return false;
    }

    @Override
    public void onNativeExceptionStart(String string, String string2, String string3) {
        block5: {
            com.alibaba.sdk.android.man.crashreporter.b.a.e("onNativeExceptionStart call back.");
            try {
                if (string != null) {
                    MotuCrashReporter.getInstance().setCrashReporterState(1);
                    com.alibaba.sdk.android.man.crashreporter.b.a.e("stuck handler is closed");
                    if (this.crashReportManager != null) {
                        this.crashReportManager.a(string2, string, string3);
                    } else {
                        com.alibaba.sdk.android.man.crashreporter.b.a.e("native: crash manager is null!");
                    }
                    break block5;
                }
                com.alibaba.sdk.android.man.crashreporter.b.a.e("native crash stack or path is null!");
                return;
            }
            catch (Exception exception) {
                com.alibaba.sdk.android.man.crashreporter.b.a.d("onNativeException err", exception);
            }
        }
    }

    @Override
    public void onNativeException(int n, int n2, long l, long l2, String string, String string2, String string3, String string4, int n3, String string5, int n4, int n5, int n6, String string6, String string7) {
        try {
            if (string4 != null) {
                if (this.crashReportManager != null) {
                    this.crashReportManager.a(string5, string4, string3);
                } else {
                    com.alibaba.sdk.android.man.crashreporter.b.a.e("native: crash manager is null!");
                }
            } else {
                com.alibaba.sdk.android.man.crashreporter.b.a.e("native crash stack or path is null!");
                return;
            }
            try {
                NativeCrashHandler.unregist();
            }
            catch (Exception exception) {
                com.alibaba.sdk.android.man.crashreporter.b.a.d("unregist native crash err", exception);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                com.alibaba.sdk.android.man.crashreporter.b.a.d("unregist native crash err,UnsatisfiedLinkError:", unsatisfiedLinkError);
            }
        }
        catch (Exception exception) {
            com.alibaba.sdk.android.man.crashreporter.b.a.d("onNativeException err", exception);
        }
    }

    static {
        try {
            System.loadLibrary("Motu");
            LOAD_SUCCESS = true;
        }
        catch (Error error) {
            com.alibaba.sdk.android.man.crashreporter.b.a.d("load motu library error.", error);
        }
    }
}

