/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man.customperf;

import com.alibaba.sdk.android.man.customperf.MANCustomPerformance;
import com.alibaba.sdk.android.man.util.MANLog;
import com.alibaba.sdk.android.man.util.ToolKit;
import java.util.regex.Pattern;

public class MANCustomPerformanceHitBuilder {
    private static final String TAG = "MAN_MANCustomPerformanceHitBuilder";
    long beginTime = -1L;
    MANCustomPerformance performance = new MANCustomPerformance();
    static Pattern pattern = Pattern.compile("[A-Za-z0-9_]*");

    public MANCustomPerformanceHitBuilder(String string) {
        if (pattern.matcher(string).matches()) {
            this.performance.setEventLabel(string);
        } else {
            MANLog.Loge(TAG, "eventLabel illegal \uff1a" + string);
        }
    }

    public MANCustomPerformanceHitBuilder hitStart() {
        this.beginTime = System.currentTimeMillis();
        return this;
    }

    public MANCustomPerformanceHitBuilder hitEnd() {
        if (this.beginTime != -1L) {
            long l = System.currentTimeMillis() - this.beginTime;
            this.performance.setDuration(l);
            MANLog.Logd(TAG, "performance.duration = " + this.performance.getDuration());
        } else {
            MANLog.Loge(TAG, "Without hitBegin");
        }
        return this;
    }

    public MANCustomPerformanceHitBuilder setDuration(long l) {
        this.performance.setDuration(l);
        return this;
    }

    public MANCustomPerformanceHitBuilder withExtraInfo(String string, String string2) {
        if (!ToolKit.isNullOrEmpty(string) && !ToolKit.isNullOrEmpty(string2)) {
            this.performance.getProperties().put(string, string2);
        }
        return this;
    }

    public MANCustomPerformance build() {
        return this.performance;
    }
}

