/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man.network;

import com.alibaba.sdk.android.man.network.MANNetworkErrorInfo;
import java.util.HashMap;

public class MANNetworkErrorCodeBuilder {
    private static final int CLIENT_ERROR_4XX = 2001;
    private static final int SERVER_ERROR_5XX = 2002;
    private static final int MALFORMED_URL_EXCEPTION = 2003;
    private static final int INTERRUPTED_IO_EXCEPTION = 2004;
    private static final int SOCKET_TIMEOUT_EXCEPTION = 2005;
    private static final int IO_EXCEPTION = 2006;

    private MANNetworkErrorCodeBuilder() {
    }

    public static MANNetworkErrorInfo buildHttpCodeClientError4XX() {
        return MANNetworkErrorCodeBuilder.buildErrorCode(2001);
    }

    public static MANNetworkErrorInfo buildHttpCodeServerError5XX() {
        return MANNetworkErrorCodeBuilder.buildErrorCode(2002);
    }

    public static MANNetworkErrorInfo buildMalformedURLException() {
        return MANNetworkErrorCodeBuilder.buildErrorCode(2003);
    }

    public static MANNetworkErrorInfo buildInterruptedIOException() {
        return MANNetworkErrorCodeBuilder.buildErrorCode(2004);
    }

    public static MANNetworkErrorInfo buildSocketTimeoutException() {
        return MANNetworkErrorCodeBuilder.buildErrorCode(2005);
    }

    public static MANNetworkErrorInfo buildIOException() {
        return MANNetworkErrorCodeBuilder.buildErrorCode(2006);
    }

    public static MANNetworkErrorInfo buildCustomErrorCode(int n) {
        return MANNetworkErrorCodeBuilder.buildErrorCode(n);
    }

    private static MANNetworkErrorInfo buildErrorCode(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ErrorCode", String.valueOf(n));
        return new MANNetworkErrorInfo(hashMap);
    }
}

