/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man.network;

import com.alibaba.sdk.android.man.network.MANNetworkErrorInfo;
import com.alibaba.sdk.android.man.network.NetworkEvent;
import java.util.HashMap;
import java.util.Map;

public class MANNetworkPerformanceHitBuilder {
    private static final String TAG = "MAN_MANNetworkPerformanceHitBuilder";
    private String requestHost;
    private String requestMethod;
    private NetworkEvent networkEvent = new NetworkEvent();
    private Map<String, String> requestProperties = new HashMap<String, String>();

    private MANNetworkPerformanceHitBuilder() {
    }

    public MANNetworkPerformanceHitBuilder(String string, String string2) {
        this.requestHost = string;
        this.requestMethod = string2 != null && (string2.equalsIgnoreCase("GET") || string2.equalsIgnoreCase("POST")) ? string2.toUpperCase() : "GET";
    }

    public MANNetworkPerformanceHitBuilder hitRequestStart() {
        this.networkEvent.requestStart();
        return this;
    }

    public MANNetworkPerformanceHitBuilder hitConnectFinished() {
        this.networkEvent.connectionEnd();
        return this;
    }

    public MANNetworkPerformanceHitBuilder hitRecievedFirstByte() {
        this.networkEvent.firstByteEnd();
        return this;
    }

    public MANNetworkPerformanceHitBuilder hitRequestEndWithLoadBytes(long l) {
        this.networkEvent.requestEndNormally(l);
        return this;
    }

    public MANNetworkPerformanceHitBuilder withExtraInfo(String string, String string2) {
        if (string != null && string2 != null) {
            this.requestProperties.put(string, string2);
        }
        return this;
    }

    public MANNetworkPerformanceHitBuilder hitRequestEndWithError(MANNetworkErrorInfo mANNetworkErrorInfo) {
        this.networkEvent.requestEndWithError(mANNetworkErrorInfo.getProperties());
        return this;
    }

    public NetworkEvent build() {
        this.requestProperties.put("Host", this.requestHost);
        this.requestProperties.put("Method", this.requestMethod);
        this.networkEvent.addMANEventProperty(this.requestProperties);
        return this.networkEvent;
    }
}

