/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man.network;

import android.util.Log;
import com.alibaba.sdk.android.man.util.EventCommitTool;
import com.alibaba.sdk.android.man.util.MANLog;
import com.alibaba.sdk.android.man.util.ToolKit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NetworkEvent {
    public static final String TAG = "MAN_NetworkEvent";
    Map<String, String> property;
    private a requestStatus;
    private long requestTimeStart = -1L;
    private long requestRT = -1L;
    private long connectTime = -1L;
    private long firstByteRT = -1L;
    private long loadBytes = 0L;

    public void addMANEventProperty(Map<String, String> map) {
        if (this.property == null) {
            this.property = map;
        } else {
            this.property.putAll(map);
        }
    }

    public void requestStart() {
        this.requestTimeStart = System.currentTimeMillis();
    }

    public void connectionEnd() {
        if (this.connectTime != -1L) {
            return;
        }
        this.connectTime = System.currentTimeMillis() - this.requestTimeStart;
        MANLog.Logd(TAG, "[connectionEnd] requestTimeStart : " + this.requestTimeStart);
    }

    public void firstByteEnd() {
        if (this.firstByteRT != -1L) {
            return;
        }
        this.firstByteRT = System.currentTimeMillis() - this.requestTimeStart;
        MANLog.Logd(TAG, "[firstByteEnd] - " + this.firstByteRT);
    }

    public void requestEndWithError(Map<String, String> map) {
        Object object;
        if (this.requestTimeStart == -1L || map == null) {
            this.requestStatus = a.c;
            return;
        }
        if (this.property != null) {
            object = map.keySet();
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (string == null || map.get(string) == null) continue;
                this.property.put(string.toString(), map.get(string).toString());
            }
        } else {
            this.property = map;
        }
        if (this.property.containsKey("ErrorCode")) {
            object = this.property.get("ErrorCode");
            try {
                int n = Integer.parseInt((String)object);
                if (!this.isDefineErrorCode(n)) {
                    this.property.remove("ErrorCode");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.property.remove("ErrorCode");
            }
        }
        this.requestStatus = a.b;
    }

    public void requestEndNormally(long l) {
        String string;
        if (this.requestTimeStart == -1L || this.requestRT != -1L) {
            MANLog.Loge(TAG, "[requestEnd] - illegal state");
            this.requestStatus = a.c;
            return;
        }
        this.loadBytes = l;
        this.requestRT = System.currentTimeMillis() - this.requestTimeStart;
        if (this.property == null) {
            this.property = new HashMap<String, String>();
        }
        if (this.property.containsKey("Host") && !ToolKit.isHost(string = this.property.get("Host")) && !ToolKit.isIp(string)) {
            this.property.remove("Host");
        }
        if (this.connectTime != -1L) {
            Log.d((String)"man", (String)("connect: " + this.connectTime));
            this.property.put("singleConnectTime", String.valueOf(this.connectTime));
        }
        if (this.firstByteRT != -1L) {
            Log.d((String)"man", (String)("connect: " + this.firstByteRT));
            this.property.put("firstPacketRT", String.valueOf(this.firstByteRT));
        }
        if (this.requestRT != -1L) {
            Log.d((String)"man", (String)("connect: " + this.requestRT));
            this.property.put("singleRequestRT", String.valueOf(this.requestRT));
        }
        if (this.loadBytes >= 0L) {
            Log.d((String)"man", (String)("loadBytes: " + this.loadBytes));
            this.property.put("singleRequestBytes", String.valueOf(this.loadBytes));
        }
        this.requestStatus = a.a;
    }

    public void reportNetworkInfo() {
        if (this.property == null) {
            this.property = new HashMap<String, String>();
        }
        if (this.requestStatus == a.a) {
            EventCommitTool.commitEvent(3002, "MAS_NET_SIG_REQUEST", this.property);
        } else if (this.requestStatus == a.b) {
            EventCommitTool.commitEvent(3004, "MAS_NET_ERR", this.property);
        } else if (this.requestStatus == a.c) {
            return;
        }
    }

    public boolean isAdvancedStat() {
        return this.connectTime != -1L || this.firstByteRT != -1L;
    }

    public boolean isDefineErrorCode(int n) {
        return n >= 1001 && n <= 1010 || n >= 2001 && n <= 2010;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        private static final /* synthetic */ a[] a;

        public static a[] values() {
            return (a[])a.clone();
        }

        public static a valueOf(String string) {
            return Enum.valueOf(a.class, string);
        }

        static {
            a = new a[]{a, b, c};
        }
    }
}

