/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man.util;

import com.alibaba.sdk.android.man.customperf.MANCustomPerformance;
import com.alibaba.sdk.android.man.util.EventCommitTool;
import com.alibaba.sdk.android.man.util.MANLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class Aggregation {
    private static String tag = "MAN_Aggregation";
    private AggregationTimerTask timerTask;
    private Timer timer;
    private final String AGGREGATION_NETWORK_PERFORMANCE_LABLE = "AGGREGATION_3002";
    private final String AGGREGATION_CUSTOM_PERFORMANCE_LABLE = "AGGREGATION_66602";
    private long totalNum = 0L;
    private final Map<String, AggregationSend> hashMap = new LinkedHashMap<String, AggregationSend>(){
        private static final long serialVersionUID = 201503121136L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, AggregationSend> entry) {
            return this.size() > 200;
        }
    };
    private final ArrayList<String> networkDefineKey = new ArrayList();

    private Aggregation() {
        this.networkDefineKey.add("singleConnectTime");
        this.networkDefineKey.add("firstPacketRT");
        this.networkDefineKey.add("singleRequestRT");
        this.networkDefineKey.add("singleRequestBytes");
        this.networkDefineKey.add("Host");
        this.networkDefineKey.add("Method");
        this.timerTask = new AggregationTimerTask();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.timerTask, 30000L, 30000L);
    }

    public static Aggregation getInstance() {
        return Singleton.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCustomPerfToAggregation(MANCustomPerformance mANCustomPerformance) {
        if (mANCustomPerformance.getProperties() != null && mANCustomPerformance.getProperties().size() != 0) {
            return false;
        }
        String string = "AGGREGATION_66602" + mANCustomPerformance.getEventLabel();
        Map<String, AggregationSend> map = this.hashMap;
        synchronized (map) {
            AggregationCustomPerf aggregationCustomPerf = (AggregationCustomPerf)this.hashMap.get(string);
            if (aggregationCustomPerf == null) {
                aggregationCustomPerf = new AggregationCustomPerf(mANCustomPerformance.getEventLabel());
                this.hashMap.put(string, aggregationCustomPerf);
            }
            aggregationCustomPerf.addCustomPerf(mANCustomPerformance.getDuration());
            ++this.totalNum;
            if (this.totalNum >= 100L) {
                this.submitAggregation();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToNetPerfAggregation(Map<String, String> map) {
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        long l4 = 0L;
        if (!this.isOnlyContainsDefineKey(map)) {
            return false;
        }
        l2 = this.convertTimeStr2Long(map.get("singleConnectTime"));
        l3 = this.convertTimeStr2Long(map.get("firstPacketRT"));
        l = this.convertTimeStr2Long(map.get("singleRequestRT"));
        try {
            l4 = Long.valueOf(map.get("singleRequestBytes"));
        }
        catch (NumberFormatException numberFormatException) {
            l4 = 0L;
        }
        String string = "AGGREGATION_3002" + map.get("Host") + map.get("Method");
        Map<String, AggregationSend> map2 = this.hashMap;
        synchronized (map2) {
            AggregationNetworkPerformance aggregationNetworkPerformance = (AggregationNetworkPerformance)this.hashMap.get(string);
            if (aggregationNetworkPerformance != null) {
                aggregationNetworkPerformance.addNetworkPerformance(l, l2, l3, l4, map.get("Method"), map.get("Host"));
            } else {
                aggregationNetworkPerformance = new AggregationNetworkPerformance();
                aggregationNetworkPerformance.addNetworkPerformance(l, l2, l3, l4, map.get("Method"), map.get("Host"));
                this.hashMap.put(string, aggregationNetworkPerformance);
            }
            ++this.totalNum;
            if (this.totalNum >= 100L) {
                this.submitAggregation();
            }
        }
        return true;
    }

    private long convertTimeStr2Long(String string) {
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    private boolean isOnlyContainsDefineKey(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        for (String string : map.keySet()) {
            if (this.networkDefineKey.contains(string)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitAggregation() {
        Map<String, AggregationSend> map = this.hashMap;
        synchronized (map) {
            this.totalNum = 0L;
            Set<String> set = this.hashMap.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (this.hashMap.get(string) != null) {
                    this.hashMap.get(string).send();
                }
                iterator.remove();
            }
        }
    }

    private class AggregationTimerTask
    extends TimerTask {
        private AggregationTimerTask() {
        }

        @Override
        public void run() {
            MANLog.Logi(tag, "timer alive.");
            Aggregation.getInstance().submitAggregation();
        }
    }

    static interface AggregationSend {
        public void send();
    }

    private class AggregationCustomPerf
    implements AggregationSend {
        private String eventLabel = "";
        private long duration = 0L;
        private int count = 0;

        public AggregationCustomPerf(String string) {
            this.eventLabel = string;
        }

        public void addCustomPerf(long l) {
            this.duration += l;
            ++this.count;
        }

        @Override
        public void send() {
            if (this.count != 0) {
                long l = this.duration / (long)this.count;
                EventCommitTool.commitEventToUT("UT", 66602, this.eventLabel, String.valueOf(this.count), String.valueOf(l), new HashMap<String, String>());
            }
        }
    }

    private class AggregationNetworkPerformance
    implements AggregationSend {
        private long requestRTSum = 0L;
        private long connectTimeSum = 0L;
        private long firstByteSum = 0L;
        private long resourceBytesSum = 0L;
        private long connectTimeCount = 0L;
        private long firstByteCount = 0L;
        private long count = 0L;
        private String requestMethod = null;
        private String requestHost = null;

        private AggregationNetworkPerformance() {
        }

        public void addNetworkPerformance(long l, long l2, long l3, long l4, String string, String string2) {
            if (l2 != -1L) {
                this.connectTimeSum += l2;
                ++this.connectTimeCount;
            }
            if (l3 != -1L) {
                this.firstByteSum += l3;
                ++this.firstByteCount;
            }
            this.resourceBytesSum += l4;
            this.requestRTSum += l;
            ++this.count;
            this.requestHost = string2;
            this.requestMethod = string;
        }

        @Override
        public void send() {
            if (this.count == 0L) {
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (this.connectTimeCount != 0L) {
                hashMap.put("singleConnectTime", String.valueOf(this.connectTimeSum / this.connectTimeCount));
                hashMap.put("CT_Num", String.valueOf(this.connectTimeCount));
            }
            if (this.firstByteCount != 0L) {
                hashMap.put("firstPacketRT", String.valueOf(this.firstByteSum / this.firstByteCount));
                hashMap.put("FP_Num", String.valueOf(this.firstByteCount));
            }
            if (this.count != 0L) {
                hashMap.put("singleRequestRT", String.valueOf(this.requestRTSum / this.count));
                hashMap.put("MasNetNum", String.valueOf(this.count));
                hashMap.put("singleRequestBytes", String.valueOf(this.resourceBytesSum / this.count));
            }
            if (this.requestHost != null && !this.requestHost.equals("")) {
                hashMap.put("Host", this.requestHost);
            }
            if (this.requestMethod != null && !this.requestMethod.equals("")) {
                hashMap.put("Method", this.requestMethod);
            }
            EventCommitTool.commitEventDirectly(3002, "MAS_NET_SIG_REQUEST", hashMap);
        }
    }

    private static class Singleton {
        static Aggregation instance = new Aggregation();

        private Singleton() {
        }
    }
}

