/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.alibaba.sdk.android.man.util.MANLog;
import java.util.regex.Pattern;

public class ToolKit {
    private static final String TAG = "MAN_ToolKit";
    private static final String validIp = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
    private static final String validHostnameRegex = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$";
    private static Pattern patternIp = Pattern.compile("^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$");
    private static Pattern patternHost = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$");

    public static Object checkNotNull(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException(String.valueOf(object2));
        }
        return object;
    }

    public static long getCurrentThreadId() {
        return Thread.currentThread().getId();
    }

    public static long convertStr2Long(String string) {
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static String getMetaDataAppKey(Context context) {
        if (context == null) {
            return "";
        }
        String string = "";
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null) {
                Object object = applicationInfo.metaData.get("com.alibaba.app.appkey");
                string = object instanceof String || object == null ? (String)object : object.toString();
                MANLog.Logi(TAG, "appKey : " + string);
            }
            if (string == null) {
                string = "";
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        return string;
    }

    public static String getMetaDataAppSecret(Context context) {
        if (context == null) {
            return "";
        }
        String string = "";
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null) {
                Object object = applicationInfo.metaData.get("com.alibaba.app.appsecret");
                string = object instanceof String || object == null ? (String)object : object.toString();
                MANLog.Logi(TAG, "appSecret : " + string);
            }
            if (string == null) {
                string = "";
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        return string;
    }

    public static String getMetaDataChannel(Context context) {
        if (context == null) {
            return "";
        }
        String string = "";
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null) {
                Object object = applicationInfo.metaData.get("ALIYUN_MAN_CHANNEL");
                string = object instanceof String || object == null ? (String)object : object.toString();
                MANLog.Logi(TAG, "channel : " + string);
            }
            if (string == null) {
                string = "";
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        return string;
    }

    public static String getMetaDataAppVersion(Context context) {
        String string = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 128);
            string = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            string = "Unknown";
        }
        if (ToolKit.isNullOrEmpty(string)) {
            string = "-";
        }
        return string;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isHost(String string) {
        if (string != null && !string.isEmpty()) {
            return patternHost.matcher(string).matches();
        }
        return false;
    }

    public static boolean isIp(String string) {
        if (string != null && !string.isEmpty()) {
            return patternIp.matcher(string).matches();
        }
        return false;
    }
}

