/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.man.util;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.alibaba.sdk.android.beacon.Beacon;
import com.alibaba.sdk.android.man.util.MANLog;
import com.alibaba.sdk.android.utils.AMSDevReporter;
import com.alibaba.sdk.android.utils.AlicloudTracker;
import com.alibaba.sdk.android.utils.AlicloudTrackerManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class UTWrapper {
    public static final String BZ_ACTIVE = "biz_active";
    public static final String BIZ_USER_ACTIVE = "biz_user_active";
    public static final String BIZ_PAGE_ACTIVE = "biz_page_active";
    public static final String BIZ_CUSTOM_ACTIVE = "biz_custom_active";
    public static final String BIZ_PERF_ACTIVE = "biz_perf_active";
    public static final String BIZ_CRASH_ACTIVE = "biz_crash_active";
    public static final String PAGE_ASSIST_TYPE = "1";
    public static final String PAGE_BASIC_TYPE = "2";
    public static final String USER_REGIST_TYPE = "1";
    public static final String USER_LOGIN_TYPE = "2";
    public static final String PERF_STANDARD_TYPE = "1";
    public static final String PERF_ADVANCE_TYPE = "2";
    public static final String PERF_CUSTOM_TYPE = "3";
    private static final String MODULE = "man";
    private static final String TAG = "UTWrapper";
    private static AlicloudTracker tracker;
    private static boolean enable;
    private static Beacon beacon;
    private static Map<String, Boolean> isAlreadySendUtMap;
    private static final Beacon.OnUpdateListener UPDATE_LISTENER;
    private static final Beacon.OnServiceErrListener ERR_LISTENER;

    public static void utInit(String string, String string2, Application application) {
        try {
            if (UTWrapper.isApkDebugable((Context)application)) {
                AMSDevReporter.setLogEnabled((boolean)true);
            }
            tracker = AlicloudTrackerManager.getInstance((Application)application).getTracker(MODULE, "1.2.4");
            tracker.setGlobalProperty("appKey", string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sdkId", MODULE);
            hashMap.put("sdkVer", "1.2.4");
            MANLog.Logd(TAG, "call utInit");
            beacon = new Beacon.Builder().appKey(string).appSecret(string2).loopInterval(3600000L).extras(hashMap).build();
            beacon.stop();
            beacon.addUpdateListener(UPDATE_LISTENER);
            beacon.addServiceErrListener(ERR_LISTENER);
            beacon.start((Context)application);
        }
        catch (Throwable throwable) {
            MANLog.Loge(TAG, "utInit Exception " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public static void commitDAUEvent(Context context) {
        if (enable && !UTWrapper.isAlreadySendUI(BZ_ACTIVE)) {
            UTWrapper.commitEvent(BZ_ACTIVE);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(AMSDevReporter.AMSSdkExtInfoKeyEnum.AMS_EXTINFO_KEY_VERSION.toString(), "1.2.4");
            AMSDevReporter.asyncReport((Context)context.getApplicationContext(), (AMSDevReporter.AMSSdkTypeEnum)AMSDevReporter.AMSSdkTypeEnum.AMS_MAN, hashMap);
        }
    }

    private static void commitEvent(String string) {
        UTWrapper.commitEvent(string, 0L, null);
    }

    public static void commitPageEvent(String string) {
        if (!enable || UTWrapper.isAlreadySendUI(BIZ_PAGE_ACTIVE + string)) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", string);
        UTWrapper.commitEvent(BIZ_PAGE_ACTIVE, 0L, hashMap);
    }

    public static void commitUserEvent(String string) {
        if (!enable || UTWrapper.isAlreadySendUI(BIZ_USER_ACTIVE + string)) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", string);
        UTWrapper.commitEvent(BIZ_USER_ACTIVE, 0L, hashMap);
    }

    public static void commitPerfEvent(String string) {
        if (!enable || UTWrapper.isAlreadySendUI(BIZ_PERF_ACTIVE + string)) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", string);
        UTWrapper.commitEvent(BIZ_PERF_ACTIVE, 0L, hashMap);
    }

    public static void commitCustomEvent() {
        if (!enable || UTWrapper.isAlreadySendUI(BIZ_CUSTOM_ACTIVE)) {
            return;
        }
        UTWrapper.commitEvent(BIZ_CUSTOM_ACTIVE);
    }

    public static void commitCrashEvent() {
        if (!enable || UTWrapper.isAlreadySendUI(BIZ_CRASH_ACTIVE)) {
            return;
        }
        UTWrapper.commitEvent(BIZ_CRASH_ACTIVE);
    }

    private static void commitEvent(String string, long l, Map<String, String> map) {
        if (!enable) {
            return;
        }
        try {
            tracker.sendCustomHit(string, l, map);
        }
        catch (Throwable throwable) {
            MANLog.Loge(TAG, "commitEvent " + string + " Exception " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public static boolean isApkDebugable(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            return (applicationInfo.flags & 2) != 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isAlreadySendUI(String string) {
        if (isAlreadySendUtMap == null) {
            isAlreadySendUtMap = new HashMap<String, Boolean>();
        }
        if (isAlreadySendUtMap.get(string) == null) {
            isAlreadySendUtMap.put(string, new Boolean(true));
            return false;
        }
        return true;
    }

    static {
        enable = true;
        isAlreadySendUtMap = new HashMap<String, Boolean>();
        UPDATE_LISTENER = new Beacon.OnUpdateListener(){

            public void onUpdate(List<Beacon.Config> list) {
                MANLog.Logi(UTWrapper.TAG, "beacon onUpdate");
                try {
                    if (beacon != null) {
                        beacon.stop();
                    }
                    if (list != null && list.size() > 0) {
                        for (Beacon.Config config : list) {
                            if (!"___man_service___".equals(config.key)) continue;
                            JSONObject jSONObject = new JSONObject(config.value);
                            if ("disabled".equals(jSONObject.optString("ut"))) {
                                MANLog.Logd(UTWrapper.TAG, "disable ut");
                                enable = false;
                                continue;
                            }
                            enable = true;
                        }
                    }
                }
                catch (Exception exception) {
                    MANLog.Loge(UTWrapper.TAG, "onUpdate Exception " + exception.getMessage());
                }
            }
        };
        ERR_LISTENER = new Beacon.OnServiceErrListener(){

            public void onErr(Beacon.Error error) {
                if (error != null) {
                    MANLog.Logi(UTWrapper.TAG, "beacon onErr:" + error.errMsg + ",errorcode:" + error.errCode);
                }
            }
        };
    }
}

