/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.ams.common.logger;

import android.util.Log;
import com.alibaba.sdk.android.ams.common.logger.LoggerListener;
import com.alibaba.sdk.android.logger.ILogger;
import com.alibaba.sdk.android.logger.LogLevel;
import com.taobao.accs.utl.AccsLogger;
import java.util.ArrayList;
import java.util.List;

public class AmsLogger {
    String TAG;
    public static volatile int log_level = 3;
    static List<LoggerListener> listener = new ArrayList<LoggerListener>();
    public static final int ERROR = 0;
    public static final int INFO = 1;
    public static final int DEBUG = 2;
    public static final String IMPORTANT_LOG_TAG = "[AMS]";

    public static AmsLogger getLogger(String string) {
        AmsLogger amsLogger = new AmsLogger();
        amsLogger.TAG = string;
        return amsLogger;
    }

    public static void addListener(final LoggerListener loggerListener) {
        listener.add(loggerListener);
        ILogger iLogger = new ILogger(){

            public void print(LogLevel logLevel, String string, String string2) {
                switch (logLevel) {
                    case ERROR: {
                        loggerListener.e(string, string2, null, 0);
                        break;
                    }
                    case WARN: {
                        loggerListener.w(string, string2, null, 0);
                        break;
                    }
                    case INFO: {
                        loggerListener.i(string, string2, null, 0);
                        break;
                    }
                    case DEBUG: {
                        loggerListener.d(string, string2, null, 0);
                    }
                }
            }
        };
        AccsLogger.addILogger((ILogger)iLogger);
    }

    public static void clearListeners() {
        listener.clear();
    }

    public void d(String string) {
        this.d(string, null, 0);
    }

    public void d(String string, Throwable throwable) {
        this.d(string, throwable, 0);
    }

    public void d(String string, Throwable throwable, int n) {
        if (log_level >= 2) {
            if (throwable == null) {
                Log.d((String)this.TAG, (String)string);
            } else {
                Log.d((String)this.TAG, (String)string, (Throwable)throwable);
            }
        }
        for (LoggerListener loggerListener : listener) {
            loggerListener.d(this.TAG, string, throwable, n);
        }
    }

    public void i(String string) {
        this.i(string, null, 0);
    }

    public void i(String string, Throwable throwable) {
        this.i(string, throwable, 0);
    }

    public void i(String string, Throwable throwable, int n) {
        if (log_level >= 1) {
            if (throwable == null) {
                Log.i((String)this.TAG, (String)string);
            } else {
                Log.i((String)this.TAG, (String)string, (Throwable)throwable);
            }
        }
        for (LoggerListener loggerListener : listener) {
            loggerListener.i(this.TAG, string, throwable, n);
        }
    }

    public void w(String string) {
        this.w(string, null, 0);
    }

    public void w(Throwable throwable) {
        this.w(null, throwable, 0);
    }

    public void w(String string, Throwable throwable) {
        this.w(string, throwable, 0);
    }

    public void w(String string, Throwable throwable, int n) {
        if (log_level >= 1) {
            if (throwable == null) {
                Log.w((String)this.TAG, (String)string);
            } else if (string == null) {
                Log.w((String)this.TAG, (Throwable)throwable);
            } else {
                Log.w((String)this.TAG, (String)string, (Throwable)throwable);
            }
        }
        for (LoggerListener loggerListener : listener) {
            loggerListener.w(this.TAG, string, throwable, n);
        }
    }

    public void e(String string) {
        this.e(string, null, 0);
    }

    public void e(String string, Throwable throwable) {
        this.e(string, throwable, 0);
    }

    public void e(String string, Throwable throwable, int n) {
        if (log_level >= 0) {
            if (throwable == null) {
                Log.e((String)this.TAG, (String)string);
            } else {
                Log.e((String)this.TAG, (String)string, (Throwable)throwable);
            }
        }
        for (LoggerListener loggerListener : listener) {
            loggerListener.e(this.TAG, string, throwable, n);
        }
    }
}

