/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.common.util;

import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import com.alibaba.sdk.android.push.common.a.b;
import com.alibaba.sdk.android.push.common.a.c;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;

public class AppInfoUtil {
    private static final String TAG = "MPS:AppInfoUtil";
    public static final int CHANNEL_SERVICE_PROCESS = 1;
    private static AmsLogger sLogger = AmsLogger.getLogger("MPS:AppInfoUtil");

    public static String getProcessName(Context context) {
        String string = "";
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                string = Application.getProcessName();
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        string = AppInfoUtil.getProcessNameByActivityThread(context);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        string = AppInfoUtil.getProcessNameByPid();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return AppInfoUtil.getProcessNameByAm(context);
    }

    private static String getProcessNameByAm(Context context) {
        String string = "";
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return string;
        }
        List list = activityManager.getRunningAppProcesses();
        if (list == null) {
            return string;
        }
        int n = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            if (runningAppProcessInfo.pid != n) continue;
            string = runningAppProcessInfo.processName;
            break;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessNameByPid() {
        int n = Process.myPid();
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            File file = new File("/proc/" + n + "/cmdline");
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
                string = bufferedReader.readLine().trim();
            }
        }
        catch (Exception exception) {
            sLogger.d("getProcessNameByPid error: " + exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return string;
    }

    private static String getProcessNameByActivityThread(Context context) {
        String string = null;
        try {
            Class<?> clazz = Class.forName("android.app.ActivityThread", false, context.getClassLoader());
            Method method = clazz.getDeclaredMethod("currentProcessName", new Class[0]);
            method.setAccessible(true);
            string = (String)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            sLogger.d("getProcessNameByActivityThread error: " + exception);
        }
        return string;
    }

    public static boolean isMainProcess(Context context) {
        String string = context.getPackageName();
        boolean bl = false;
        try {
            String string2 = context.getPackageManager().getPackageInfo((String)string, (int)0).applicationInfo.processName;
            String string3 = AppInfoUtil.getProcessName(context);
            if (!string2.equals("") && string2.equalsIgnoreCase(string3)) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            sLogger.e("isMainProcess:get process name failed.", throwable);
        }
        return bl;
    }

    public static boolean isChannelProcess(Context context) {
        boolean bl = false;
        try {
            String string = context.getPackageName() + c.d();
            String string2 = AppInfoUtil.getProcessName(context);
            if (!string.equals("") && string.equalsIgnoreCase(string2)) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            sLogger.e("isChannelProcess:get process name failed.", throwable);
        }
        return bl;
    }

    public static boolean isComponentExists(Context context, String string, String string2) {
        if (null != context) {
            PackageManager packageManager = context.getPackageManager();
            String string3 = context.getPackageName();
            ComponentName componentName = new ComponentName(string3, string);
            boolean bl = true;
            try {
                if (string2.equals("service")) {
                    ServiceInfo serviceInfo = packageManager.getServiceInfo(componentName, 131584);
                } else if (string2.equals("activity")) {
                    ActivityInfo activityInfo = packageManager.getActivityInfo(componentName, 131584);
                } else if (string2.equals("receiver")) {
                    ActivityInfo activityInfo = packageManager.getReceiverInfo(componentName, 131584);
                } else {
                    bl = false;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                sLogger.e("component:" + string + " not found!");
                bl = false;
            }
            return bl;
        }
        sLogger.e("Get component info failed: context null");
        return false;
    }

    public static boolean isPermissionGranted(Context context, String string) {
        if (null != context) {
            boolean bl = false;
            try {
                PackageManager packageManager = context.getPackageManager();
                bl = 0 == packageManager.checkPermission(string, context.getPackageName());
            }
            catch (Throwable throwable) {
                sLogger.e("isPermissionGranted:Get permission info failed.", throwable);
            }
            return bl;
        }
        sLogger.e("Get permission info failed: context null");
        return false;
    }

    public static String getAppVersionName(Context context) {
        if (null != context) {
            PackageManager packageManager = context.getPackageManager();
            String string = null;
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                string = packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                sLogger.e("version name not found!", nameNotFoundException);
            }
            return string;
        }
        sLogger.e("Get app version name failed: context null");
        return null;
    }

    public static String getChannelServiceData(Context context, int n) {
        try {
            String string;
            PackageManager packageManager = context.getPackageManager();
            String string2 = context.getPackageName();
            ComponentName componentName = new ComponentName(string2, b.a.a());
            ServiceInfo serviceInfo = packageManager.getServiceInfo(componentName, 131584);
            switch (n) {
                case 1: {
                    string = serviceInfo.processName;
                    break;
                }
                default: {
                    string = null;
                }
            }
            return string;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            sLogger.e("Meta data name " + b.a.a() + " not found!");
            return null;
        }
    }
}

