/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.common.util;

import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolFactory {
    private static volatile ScheduledThreadPoolExecutor scheduleThreadPoolExecutor;
    private static final AtomicInteger integer;
    private static final String TAG = "MPS:ThreadPoolFactory";
    private static AmsLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduledThreadPoolExecutor getScheduledExecutor() {
        if (scheduleThreadPoolExecutor != null) return scheduleThreadPoolExecutor;
        Class<ThreadPoolFactory> clazz = ThreadPoolFactory.class;
        synchronized (ThreadPoolFactory.class) {
            if (scheduleThreadPoolExecutor != null) return scheduleThreadPoolExecutor;
            scheduleThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new a(TAG));
            scheduleThreadPoolExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
            scheduleThreadPoolExecutor.allowCoreThreadTimeOut(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return scheduleThreadPoolExecutor;
        }
    }

    public static ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        ScheduledFuture<?> scheduledFuture = null;
        try {
            scheduledFuture = ThreadPoolFactory.getScheduledExecutor().schedule(runnable, l, timeUnit);
        }
        catch (Throwable throwable) {
            logger.e("ThreadPoolExecutorFactory schedule", throwable);
        }
        return scheduledFuture;
    }

    public static void execute(Runnable runnable) {
        try {
            ThreadPoolFactory.getScheduledExecutor().execute(runnable);
        }
        catch (Throwable throwable) {
            logger.e("ThreadPoolExecutorFactory execute", throwable);
        }
    }

    static {
        integer = new AtomicInteger();
        logger = AmsLogger.getLogger(TAG);
    }

    static class a
    implements ThreadFactory {
        private String a;

        public a(String string) {
            this.a = string;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            int n = integer.getAndIncrement();
            Thread thread = new Thread(runnable, this.a + n);
            thread.setPriority(5);
            return thread;
        }
    }
}

